/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.guiframework.view.descriptors;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestManager;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.DisplayField;
import com.iplanet.jato.view.View;

import com.sun.enterprise.tools.guiframework.exception.FrameworkException;

import com.sun.web.ui.model.CCWizardWindowModel;
import com.sun.web.ui.model.CCWizardWindowModelInterface;
import com.sun.web.ui.view.wizard.CCWizardWindow;


/**
 *
 */
public class CCWizardWindowDescriptor extends DisplayFieldDescriptor {

    /**
     *	Constructor
     */
    public CCWizardWindowDescriptor(String name) {
	super(name);
    }


    /**
     *	<P>This is a factory method.  It will create a CCWizardWindow.</P>
     *
     *	<P>Several parameters are used to initialize the CCWizardWindowModel
     *	that is passed to the new CCWizardWindow object.  Below is a list of
     *	supported parameters that may be defined in the viewXML:</P>
     *  
     *	<UL><LI>MASTHEAD_IMAGE</LI>
     *	    <LI>MASTHEAD_ALT_TEXT</LI>
     *	    <LI>RESOURCE_BUNDLE</LI>
     *	    <LI>BUNDLE_ID</LI>
     *	    <LI>WIZARD_TITLE</LI>
     *	    <LI>WIZARD_CLASS_NAME</LI>
     *	    <LI>WIZARD_NAME</LI>
     *	    <LI>WIZARD_WINDOW_NAME</LI>
     *	    <LI>BUTTON_LABEL</LI>
     *	    <LI>WIZARD_REFRESH_CMDCHILD</LI></UL>
     *
     *	@param	ctx		The RequestContext
     *	@param	container	The container for the newly created
     *	@param	name		The Name of the View to be created.
     */
    public View getInstance(RequestContext ctx, ContainerView container, String name) {
	CCWizardWindowModelInterface wizModel = new CCWizardWindowModel();

	// Masthead Image
	String image = (String)getParameter(MASTHEAD_IMAGE);
	if (image != null) {
	    wizModel.setValue(CCWizardWindowModelInterface.MASTHEAD_SRC, image);
	}
	// Masthead Alt Text
	String alt = (String)getParameter(MASTHEAD_ALT_TEXT);
	if (alt != null) {
	    wizModel.setValue(CCWizardWindowModelInterface.MASTHEAD_ALT, alt);
	}
	// Resource file location
	String resource = getResourceBundle();
	if (resource != null) {
	    wizModel.setValue(CCWizardWindowModelInterface.BASENAME, resource);
	}
	// Bundle id
	String bundle = (String)getParameter(BUNDLE_ID);
	if (bundle != null) {
	    wizModel.setValue(CCWizardWindowModelInterface.BUNDLEID, bundle);
	}
	// Wizard title
	String title = (String)getParameter(WIZARD_TITLE);
	if (title != null) {
	    wizModel.setValue(CCWizardWindowModelInterface.TITLE, title);
	}
	// Wizard impl class name
	String className = (String)getParameter(WIZARD_CLASS_NAME);
	if (className != null) {
	    wizModel.setValue(CCWizardWindowModelInterface.WIZARD_CLASS_NAME, className);
	}
	// Wizard Name
	String wizName = (String)getParameter(WIZARD_NAME);
	if (wizName != null) {
	    wizModel.setValue(CCWizardWindowModelInterface.WIZARD_NAME, wizName);
	}
	// Wizard Window Name
	String wizWindowName = (String)getParameter(WIZARD_WINDOW_NAME);
	if (wizWindowName != null) {
	    wizModel.setValue(CCWizardWindowModelInterface.WIZARD_WINDOW_NAME, wizWindowName);
	}
	// Button label
	String label = (String)getParameter(BUTTON_LABEL);
	if (label != null) {
	    wizModel.setValue(CCWizardWindowModelInterface.WIZARD_BUTTON_FORM, label);
	}
	// Wizard refresh command child
	String wizRefresh = (String)getParameter(WIZARD_REFRESH_CMDCHILD);
	if (wizRefresh != null) {
	    wizModel.setValue(CCWizardWindowModelInterface.WIZARD_REFRESH_CMDCHILD, wizRefresh);
	}

	// Hack to mark a flag that the Wizard was invoked for the first time
	// and should reset the model data
	wizModel.setValue(RESET_MODEL_DATA, "true");
	
	return new CCWizardWindow(container, wizModel, name, label);
    }


    /**
     *	mastheadImage
     */
    public static final String	MASTHEAD_IMAGE	  	= "mastheadImage";

    /**
     *	mastheadAltText
     */
    public static final String	MASTHEAD_ALT_TEXT 	= "mastheadAltText";

    /**
     *	bundleId
     */
    public static final String  BUNDLE_ID         	= "bundleId";

    /**
     *	wizardTitle
     */
    public static final String  WIZARD_TITLE      	= "wizardTitle";

    /**
     *	wizardClassName
     */
    public static final String  WIZARD_CLASS_NAME 	= "wizardClassName";

    /**
     *	wizardName
     */
    public static final String  WIZARD_NAME       	= "wizardName";

    /**
     *	wizardWindowName
     */
    public static final String	WIZARD_WINDOW_NAME	= "wizardWindowName";

    /**
     *	buttonLabel
     */
    public static final String  BUTTON_LABEL      	= "buttonLabel";

    /**
     *	wizardRefreshCmd
     */
    public static final String	WIZARD_REFRESH_CMDCHILD	= "wizardRefreshCmd";

    /**
     *	resetModelData
     */
    public static final String	RESET_MODEL_DATA	= "resetModelData";
}
