/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.guiframework.view.event;

import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBean;

import com.sun.enterprise.tools.guiframework.view.descriptors.ViewDescriptor;

import java.util.EventObject;


/**
 *  This event object will be created and used when an error is caught by the
 *  framework and there is an error handler defined to take care of the
 *  exception.
 */
public class ErrorEvent extends EventObject {

    /**
     *	This is the constructor for a ErrorEvent.  You must specify the
     *	ViewDescriptor (the ViewDescriptor containing the error handler).
     *
     *	@param	src		The View described by ViewDescriptor
     *	@param	desc		The ViewDescriptor containing the error handler
     *  @param	vb		The ViewBean
     *	@param	ex		The Exception / Error
     *	@param	causeView	The View responsible for the Exception / Error
     *	@param	causeDesc	The responsible ViewDescrptor
     *	@param	exMsg		Short exception message
     *	@param	exClass		The Exception type (class name)
     *	@param	causeMsg	The root cause short exception message
     *	@param	causeClass	The root cause exception type (class name)
     *	@param	fullTrace	The full stackTrace to the root cause
     *	@param	regTrace	The regular stackTrace
     */
    public ErrorEvent(View src, ViewDescriptor desc, ViewBean vb, Throwable ex,
		      View causeView, ViewDescriptor causeDesc, String exMsg,
		      String exClass, String causeMsg, String causeClass,
		      String fullTrace, String regTrace) {
	super((src == null) ? (Object)((desc == null) ? (Object)"" : (Object)desc) : (Object)src);
	setView(src);
	setViewDescriptor(desc);
	setViewBean(vb);
	setException(ex);
	setCauseView(causeView);
	setCauseViewDescriptor(causeDesc);
	setExceptionMessage(exMsg);
	setExceptionClassName(exClass);
	setCauseMessage(causeMsg);
	setCauseClassName(causeClass);
	setFullTrace(fullTrace);
	setRegularTrace(regTrace);
    }


    /**
     *
     */
    protected void setView(View view) {
	_view = view;
    }


    /**
     *	This method returns the View corresponding to the ViewDescriptor that
     *	is handling this error event.  This is not necessarily the same View
     *	where the event occurred.  Also, this View may be null if for some
     *	reason the View could not be instantiated (in this case, this would
     *	likely be the reason of the error).
     *
     *	@return The View associated with the handling ViewDescriptor
     */
    public View getView() {
	return _view;
    }


    /**
     *	This method sets the ViewDescriptor for the object that is about to be
     *	created.
     *
     *	@param	viewDesc	The ViewDescriptor of the View to be created.
     */
    protected void setViewDescriptor(ViewDescriptor viewDesc) {
	_viewDesc = viewDesc;
    }


    /**
     *	This method retrieves the ViewDescriptor of the View containing the
     *	error handler.  This ViewDescriptor is not necessarily the
     *	ViewDescriptor where the error occurred.  This can be null if no error
     *	handler was specified in the chain of ViewDescriptors (in this case the
     *	Servlet's default error handling will be using this ErrorEvent).
     *
     *	@return The ViewDescriptor describing this ErrorEvent
     */
    public ViewDescriptor getViewDescriptor() {
	return _viewDesc;
    }


    /**
     *
     */
    protected void setViewBean(ViewBean vb) {
	_viewBean = vb;
    }


    /**
     *	This method returns the ViewBean.
     *
     *	@return	The ViewBean
     */
    public ViewBean getViewBean() {
	return _viewBean;
    }


    /**
     *
     */
    protected void setException(Throwable ex) {
	_exception = ex;
    }


    /**
     *	This returns the Exception / Error that was caught.  This is not the
     *	root cause.
     */
    public Throwable getException() {
	return _exception;
    }


    /**
     *
     */
    protected void setCauseView(View causeView) {
	_causeView = causeView;
    }


    /**
     *	This method returns the View that was indicated as being responsible
     *	for the error.  The View may be null or a parent of the View that
     *	actually had the problem.
     *
     *	@return The responsible View.
     */
    public View getCauseView() {
	return _causeView;
    }


    /**
     *
     */
    protected void setCauseViewDescriptor(ViewDescriptor causeDesc) {
	_causeDesc = causeDesc;
    }


    /**
     *	This method returns the ViewDescriptor of the View that had a problem.
     *	This is not likely to be null, but it is possible.  The ViewDescriptor
     *	returned may not correspond directly to the View that had the problem.
     *	If the View that had a problem does not have a corresponding
     *	ViewDescriptor, the closest ViewDescriptor to that View will be used.
     *
     *	@return ViewDescriptor corresponding to View which caused the error
     */
    public ViewDescriptor getCauseViewDescriptor() {
	return _causeDesc;
    }


    /**
     *
     */
    protected void setExceptionMessage(String exMsg) {
	_exceptionMessage = exMsg;
    }


    /**
     *	This method returns the Message associated with the Exception (not the
     *	root cause exception).
     *
     *	@return ex.getMessage();
     */
    public String getExceptionMessage() {
	return _exceptionMessage;
    }


    /**
     *
     */
    protected void setExceptionClassName(String exClass) {
	_exceptionClass = exClass;
    }


    /**
     *	This method returns the name of the Exception Class (e.g.
     *	"java.lang.RuntimeException")
     *
     *	@return The Class name of the Exception / Error
     */
    public String getExceptionClassName() {
	return _exceptionClass;
    }


    /**
     *
     */
    protected void setCauseMessage(String causeMsg) {
	_causeMessage = causeMsg;
    }


    /**
     *	This method returns the message of the root cause exception.
     *
     *	@return The cause exception message.
     */
    public String getCauseMessage() {
	return _causeMessage;
    }


    /**
     *
     */
    protected void setCauseClassName(String causeClass) {
	_causeClass = causeClass;
    }


    /**
     *	This method returns the Class Name of the root cause exception.
     *
     *	@return The Class name of the root cause exception.
     */
    public String getCauseClassName() {
	return _causeClass;
    }


    /**
     *
     */
    protected void setFullTrace(String fullTrace) {
	_fullTrace = fullTrace;
    }


    /**
     *	This method returns a full stack trace to the root cause.  If the root
     *	cause is caught 1 or more times, this will not be shown in this stack
     *	trace.  This stack trace only has the instructions that were invoked to
     *	reach the root cause.
     *
     *	@return	The full stack trace to the root cause.
     */
    public String getFullTrace() {
	return _fullTrace;
    }


    /**
     *
     */
    protected void setRegularTrace(String regTrace) {
	_regularTrace = regTrace;
    }


    /**
     *	This method returns the traditional stack trace.  This stack trace will
     *	show each catch clause that caught the root cause.  It may also omit
     *	some of the details.
     *
     *	@return Stack trace
     */
    public String getRegularTrace() {
	return _regularTrace;
    }


    private View _view = null;
    private ViewDescriptor _viewDesc = null;
    private ViewBean _viewBean = null;
    private Throwable _exception = null;
    private View _causeView = null;
    private ViewDescriptor _causeDesc = null;
    private String _exceptionMessage = null;
    private String _exceptionClass = null;
    private String _causeMessage = null;
    private String _causeClass = null;
    private String _fullTrace = null;
    private String _regularTrace = null;
}
