/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin/mbeanapi-impl/src/java/com/sun/enterprise/management/config/ConfigConfigFactory.java,v 1.8 2006/03/17 03:34:15 llc Exp $
 * $Revision: 1.8 $
 * $Date: 2006/03/17 03:34:15 $
 */
package com.sun.enterprise.management.config;

import java.util.Map;
import java.util.Set;
import java.util.Collections;
import java.util.Properties;

import javax.management.ObjectName;
import javax.management.AttributeList;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.ReflectionException;


import com.sun.appserv.management.base.XTypes;
import com.sun.enterprise.management.config.AMXConfigImplBase;
import com.sun.enterprise.management.support.Delegate;

import com.sun.appserv.management.base.XTypes;

import com.sun.appserv.management.config.ConfigConfig;
import com.sun.appserv.management.config.ConfigConfigKeys;

import com.sun.appserv.management.util.jmx.JMXUtil;

import com.sun.appserv.management.util.misc.GSetUtil;

import com.sun.enterprise.management.support.ObjectNames;
import com.sun.enterprise.management.support.oldconfig.OldConfigsMBean;

/**
 */
public final class ConfigConfigFactory extends ConfigFactory
{
    private String  mSrcConfigName;
    private String  mNewConfigName;
    
		public
	ConfigConfigFactory( final ConfigFactoryCallback callbacks )
	{
		super( callbacks );
		
		mSrcConfigName  = null;
		mNewConfigName  = null;
	}
	
	private final Set<String>	LEGAL_OPTIONAL_KEYS	= 
		GSetUtil.newUnmodifiableStringSet(
		ConfigConfigKeys.DYNAMIC_RECONFIGURATION_ENABLED_KEY,
		ConfigConfigKeys.SRC_CONFIG_NAME_KEY );
	
	    protected Set<String>
	getLegalOptionalCreateKeys()
	{
		return( LEGAL_OPTIONAL_KEYS );
	}
	
	
		protected ObjectName
	createOldChildConfig(
	    final AttributeList translatedAttrs,
	    final Properties    props )
	{
		trace( "ConfigConfigFactory.createOldChildConfig: creating using: " +
		    stringify( translatedAttrs ) );

        final OldConfigsMBean  old = getOldConfigProxies().getOldConfigsMBean();
        
		final ObjectName objectName = old.copyConfiguration( mSrcConfigName, mNewConfigName, props);

		return( objectName );
	}

		public ObjectName
	create(
	    final String name,
	    final Map<String,String> optional)
	{
		final String[] requiredParams = new String[] {};
		final Map<String,String> params = initParams(name, requiredParams, optional);
		
		mNewConfigName  = name;
        mSrcConfigName   = (String)optional.get( ConfigConfigKeys.SRC_CONFIG_NAME_KEY );
        if ( mSrcConfigName == null )
        {
            mSrcConfigName   = ConfigConfigKeys.DEFAULT_SRC_CONFIG_NAME;
        }
        
        
		final ObjectName amxName = createNamedChild(name, params);
		
        
		// set any optional params
		if ( amxName != null )
		{
		    final ConfigConfig  config  = getCallbacks().getProxyFactory().getProxy( amxName, ConfigConfig.class);
		    
    		Object value;
    		
    		value   = optional.get( ConfigConfigKeys.DYNAMIC_RECONFIGURATION_ENABLED_KEY );
    		if ( value != null )
    		{
    		    config.setDynamicReconfigurationEnabled( Boolean.parseBoolean( "" + value ) );
    		}
		}
		
		return( amxName );
	}


		protected void
	removeByName(String name)
	{
		getOldConfigProxies().getOldConfigsMBean().deleteConfiguration(name);
	}
}




