/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin/mbeanapi-impl/src/java/com/sun/enterprise/management/config/ModuleMonitoringLevelsConfigImpl.java,v 1.8 2006/03/09 20:30:40 llc Exp $
 * $Revision: 1.8 $
 * $Date: 2006/03/09 20:30:40 $
 */
package com.sun.enterprise.management.config;

import java.util.Map;
import java.util.HashMap;

import javax.management.Attribute;
import javax.management.AttributeList;

import com.sun.appserv.management.config.ModuleMonitoringLevelsConfig;
import com.sun.appserv.management.util.jmx.JMXUtil;
import com.sun.enterprise.management.config.AMXConfigImplBase;
import com.sun.enterprise.management.support.Delegate;

/**

 */
public final class ModuleMonitoringLevelsConfigImpl  extends AMXConfigImplBase
{
		public
	ModuleMonitoringLevelsConfigImpl( final Delegate delegate )
	{
		super( delegate );
	}

	private static final String[] MODULES	=
	{
		"ConnectorConnectionPool",
		"ThreadPool",
		"HTTPService",
		"JDBCConnectionPool",
		"ORB",
		"JVM",
		"JMSService",
		"ConnectorService",
		"TransactionService",
		"WebContainer",
		"EJBContainer",
	};
	
		public Map<String,String>
	getAllLevels()
	{
		final AttributeList	attrs	= getAttributes( MODULES );
		
		assert ( attrs.size() == MODULES.length ) :
			"Missing some monitoring levels, have: " + toString( attrs );
		
		return( JMXUtil.attributeListToStringMap( attrs ) );
	}
	
		public void
	changeAll( final String state )
	{
		final AttributeList	allAttrs	= new AttributeList();
		
		for( int i = 0; i < MODULES.length; ++i )
		{
			allAttrs.add( new Attribute( MODULES[ i ], state ) );
		}
		
		setAttributes( allAttrs );
	}

}

