/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.management.offline;

import java.util.Map;
import java.util.HashMap;
import java.util.Set;
import java.util.HashSet;
import java.util.Collections;

import javax.management.ObjectName;
import javax.management.MBeanServer;

import com.sun.appserv.management.base.DottedNames;
import com.sun.appserv.management.base.AMXDebug;


/**
 */
public final class OfflineDottedNamesMgr
{
    private final OfflineDottedNamesRegistry   mRegistry;
    private final OfflineDottedNamePrefixes    mPrefixes;
    private final MBeanServer                  mServer;
    
		public
	OfflineDottedNamesMgr( final MBeanServer server )
	{
	    mServer = server;
	    
	    mRegistry   = new OfflineDottedNamesRegistry();
	    mPrefixes   = OfflineDottedNamePrefixes.getInstance();
	}
	
	    private void
	debug( final Object o )
	{
	    AMXDebug.getInstance().getOutput( "OfflineDottedNamesMgr" ).println( o );
	}
	
	    private String
	getPrefix( final String dottedName )
	{
	    final int   idx = dottedName.lastIndexOf( dottedName );
	    if ( idx <= 0 )
	    {
	        throw new IllegalArgumentException( dottedName );
	    }
	    return dottedName.substring( 0, idx - 1 );
	}
	
	    private String
	getAttrName( final String dottedName )
	{
	    final String    prefix  = getPrefix( dottedName );
	    
	    return dottedName.substring( prefix.length() + 1, dottedName.length() );
	}
	
	    public void
	refresh()
	{
	    // nothing to do--we're always "live"
	}
	
		public Object[]
	dottedNameGet( final String[] names )
	{
	    final Object[]  results = new Object[ names.length ];
	    
	    for( int i = 0; i < names.length; ++i )
	    {
	        try
	        {
	            results[ i ]    = dottedNameGet( names[ i ] );
	        }
	        catch( Exception e )
	        {
	            results[ i ]    = e;
	        }
	    }
        
        return results;
	}
	
	private final String WILD_ALL   = "*";
	
		public Object
	dottedNameGet( final String dottedName )
	{
	    final String        prefix      = getPrefix( dottedName );
	    final ObjectName    objectName  = mRegistry.getObjectName( prefix );
	    
	    if ( objectName == null )
	    {
	        throw new IllegalArgumentException( dottedName );
	    }
	    
	    final String attrName   = getAttrName( dottedName );
	    
	    debug( "dottedNameGet: " + dottedName + ", prefix = " + prefix +
	        "attrName = " + attrName );
	    
	    Object value    = null;
	    try
	    {
	        value   = mServer.getAttribute( objectName, attrName );
	    }
	    catch( Exception e )
	    {
	        value   = e;
	    }
	    debug( "dottedNameGet: " + dottedName + " = " + value );
		return value;
	}
	
		public Object[]
	dottedNameList( final String[] names )
	{
		return new String[0];
	}
	
		public Object[]
	dottedNameSet( final String[] nameValuePairs )
	{
	    for( final String pair : nameValuePairs )
	    {
	    }
	    throw new UnsupportedOperationException( "dottedNameSet" );
	}
	
}
































