/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 

package com.sun.enterprise.management.offline;

import java.util.logging.Logger;
import java.io.File;

import javax.management.MBeanServer;

import com.sun.enterprise.management.support.MBeanImplBase;
import com.sun.enterprise.management.support.BootUtil;



/**
	Implements loading of all MBean API MBeans.
 */
public final class OfflineLoader extends MBeanImplBase
	implements OfflineLoaderMBean
{
	
	private final File           mDomainXML;
	final MBeanServer            mServer;
	final ConfigDelegateFactory  mDelegateFactory;
	private final AMXLoader      mAMXLoader;
	
		public
	OfflineLoader(
	    final MBeanServer   server,
	    final File          domainXML )
	{
	    mServer     = server;
	    mDomainXML  = domainXML;
	    
	    final boolean   offline = true;
		BootUtil.init( offline );
		
		try
		{
		    mDelegateFactory    = ConfigDelegateFactory.getInstance( mDomainXML );
		    mAMXLoader  = new AMXLoader( mServer, mDelegateFactory );
		}
		catch( Exception e )
		{
		    e.printStackTrace();
		    throw new RuntimeException( e );
		}
		
		
		start();
	}

	
	    protected String
	getDebugID(  )
	{
	    return( "OfflineLoader" );
	}
	
	    protected void
	sdebug( Object o )
	{
	    debug( o );
	    System.out.println( "" + o );
	}
	
		public String
	getAMXJMXDomainName()
	{
		return( BootUtil.getInstance().getAMXJMXDomainName() );
	}
	
		public String
	getAdministrativeDomainName()
	{
		return( BootUtil.getInstance().getAppserverDomainName() );
	}
	
	
		protected Logger
	createLogger()
	{
	    return Logger.getLogger( this.getClass().getName() ) ;
	}
	
		private void
	start()
	{
		try
		{
		    mAMXLoader.loadAll();
		}
		catch( Exception e )
		{
		    e.printStackTrace();
		    throw new RuntimeException( e );
		}
		
        BootUtil.getInstance().setAMXReady( true );
	}
}








