/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */
 
/*
 */

package com.sun.enterprise.management.support;


/**
 */
public interface AMXDebugSupportMBean
{
    public static final String OBJECT_NAME  = "amx-support:name=amx-debug";
    
    /**
        @return default AMX debug state
     */
    public boolean  getDefaultDebug();
    
    /**
        Set the default AMX debug state for any new debug outputs.
     */
    public void     setDefaultDebug( boolean enabled ); 
    
    /**
        @return names of all Outputs in use
     */
    public String[]  getOutputIDs( ); 
    
    
    /**
        @return the debug state for the specified ID
     */
    public boolean  getDebug( final String id ); 
    
    /**
        Set the debug state for the specified ID.
     */
    public void     setDebug( final String id, final boolean enabled ); 
    
    /**
        Set the AMX debug state for all existing new debug outputs.
        These may or may not be MBeans, and an MBean may or may
        not be in debugging mode and using its output.
     */
    public void     setAll( final boolean debug );
    
    /**
        Get rid of all output files.
     */
    public void     cleanup();
    
    /**
        Get the output for the specified ID.
     */
    public String   getOutputFrom( final String id );
}








