/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */
 
/*
 * $Header: /cvs/glassfish/admin/mbeanapi-impl/src/java/com/sun/enterprise/management/support/DelegateInvocationHandler.java,v 1.2 2005/12/25 03:40:40 tcfujii Exp $
 * $Revision: 1.2 $
 * $Date: 2005/12/25 03:40:40 $
 */

package com.sun.enterprise.management.support;

import java.lang.reflect.Proxy;
import java.lang.reflect.Method;
import java.lang.reflect.InvocationHandler;

import com.sun.appserv.management.util.misc.ClassUtil;

/**
 */
public final class DelegateInvocationHandler implements InvocationHandler
{
	private final Delegate	mDelegate;
	
		private
	DelegateInvocationHandler( final Delegate delegate )
	{
		mDelegate	= delegate;
	}
	
		static public Object
	newProxyInstance(
		Delegate	delegate,
		Class		interfaceClass )
	{
		final DelegateInvocationHandler	handler	=
			new DelegateInvocationHandler( delegate );
			
		final ClassLoader		classLoader	= interfaceClass.getClassLoader();
		
		final Class[]	interfaces	= new Class[] { interfaceClass };
		final Object proxy	= Proxy.newProxyInstance( classLoader,
							interfaces, handler);
		
		return( proxy );
	}
	
	/**
		Just forward whatever it is to the Delegate
	 */
		public Object
	invoke(
		Object		proxy,
    	Method		method,
		Object[]	args
		)
   		throws java.lang.Throwable
   	{
   		final Class[]	sig	= method.getParameterTypes();
   		
   		return( mDelegate.invoke( method.getName(), args, ClassUtil.classnamesFromSignature( sig ) ) );
   	}
	
}











