/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin/mbeanapi-impl/tests/com/sun/enterprise/management/DomainRootTest.java,v 1.5 2005/12/25 03:41:17 tcfujii Exp $
 * $Revision: 1.5 $
 * $Date: 2005/12/25 03:41:17 $
 */
package com.sun.enterprise.management;

import java.util.Set;
import java.util.Map;
import java.util.Iterator;
import java.io.IOException;

import javax.management.ObjectName;
import javax.management.AttributeList;
import javax.management.MBeanServerConnection;
import javax.management.NotCompliantMBeanException;

import com.sun.appserv.management.DomainRoot;
import com.sun.appserv.management.j2ee.J2EEDomain;
import com.sun.appserv.management.base.NotificationEmitterService;


import com.sun.appserv.management.util.jmx.MBeanServerConnectionConnectionSource;

import com.sun.enterprise.management.support.AMXNonConfigImplBase;
import com.sun.enterprise.management.support.QueryMgrImpl;

import com.sun.appserv.management.util.misc.ExceptionUtil;

/**
 */
public final class DomainRootTest extends AMXTestBase
{

		public
	DomainRootTest( )
		throws IOException
	{
	}

		public void
	testGetDomain()
	{
		getDomainRoot();
	}
	
		public void
	testGetDeploymentMgr()
	{
		assert( getDomainRoot().getDeploymentMgr() != null );
	}
	
		public void
	testGetConfigDottedNames()
	{
	    if ( checkNotOffline( "testGetConfigDottedNames" ) )
	    {
		    assert( getDomainRoot().getConfigDottedNames() != null );
	    }
	}
	
		public void
	testGetMonitoringDottedNames()
	{
	    if ( checkNotOffline( "testGetConfigDottedNames" ) )
	    {
		    assert( getDomainRoot().getMonitoringDottedNames() != null );
		}
	}
	
	
		public void
	testGetDomainNotificationEmitterService()
	{
		assert( getDomainRoot().getDomainNotificationEmitterService() != null );
	}
	
	
		public void
	testGetDomainNotificationEmitterServiceMap()
	{
	    final Map<String,NotificationEmitterService> services    =
	        getDomainRoot().getNotificationEmitterServiceMap();
		assert( services != null );
		
		for( NotificationEmitterService s : services.values() )
		{
		    s.getListenerCount();
		}
	}
	
	
		public void
	testAMXReady()
	{
	    final DomainRoot    domainRoot  = getDomainRoot();
	    
	    while ( ! domainRoot.getAMXReady() )
	    {
	        mySleep( 10 );
	    }
	}
	
		public void
	testWaitAMXReady()
	{
	    final DomainRoot    domainRoot  = getDomainRoot();
	    
	    domainRoot.waitAMXReady();
	}
}


