/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.management;

import java.io.File;
import java.io.IOException;

import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;


import com.sun.appserv.management.client.TrustStoreTrustManager;


public final class TestClientTrustStoreTrustManager
	extends TrustStoreTrustManager
{
		public
	TestClientTrustStoreTrustManager(  )
	{
		this( new File( "./TestClient-TrustStore" ), "changeme".toCharArray() );
	}
	
		public
	TestClientTrustStoreTrustManager( final File trustStore, final char[] password )
	{
		super( trustStore, password ); 
	}
	
		protected boolean
	shouldAddToTrustStore( final Certificate c )
	{
		// we are testing; don't bother the user
		return( true );
	}
	
		protected void
	addCertificateToTrustStore(
		final String		alias,
		final Certificate	c )
		throws IOException,
		KeyStoreException, NoSuchAlgorithmException, CertificateException
	{
		super.addCertificateToTrustStore( alias, c );
		System.out.println( "added certificate to truststore: " + c );
	}
}