/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.management.base;

import java.util.Set;
import java.util.HashSet;
import java.util.Map;
import java.util.HashMap;


import javax.management.MBeanServerConnection;
import javax.management.MBeanInfo;
import javax.management.MBeanAttributeInfo;
import javax.management.ObjectName;
import javax.management.Attribute;
import javax.management.AttributeList;

import com.sun.appserv.management.base.AMX;
import com.sun.appserv.management.base.Util;


import com.sun.appserv.management.util.misc.MapUtil;
import com.sun.appserv.management.util.misc.CollectionUtil;
import com.sun.appserv.management.util.misc.GSetUtil;
import com.sun.appserv.management.util.misc.StringUtil;
import com.sun.appserv.management.util.jmx.JMXUtil;

import com.sun.appserv.management.config.Enabled;

import com.sun.enterprise.management.AMXTestBase;


/**
 */
public final class GetSetAttributeTest extends AMXTestBase
{
    public GetSetAttributeTest()
    {
    }


		private void
	testGetSetAttributes(final AMX   amx)
	    throws Exception
	{
		final ObjectName    objectName  = Util.getObjectName( amx );
	    final MBeanServerConnection conn    = getMBeanServerConnection();
		final MBeanInfo mbeanInfo   = Util.getExtra( amx ).getMBeanInfo();
		
		final Map<String,MBeanAttributeInfo>    attrInfos   =
		    JMXUtil.attributeInfosToMap( mbeanInfo.getAttributes() );
		final String[]  attrNames   = GSetUtil.toStringArray( attrInfos.keySet() );
		final AttributeList values  = conn.getAttributes( objectName, attrNames );
		
		final Map<String,Object>    valuesMap   = JMXUtil.attributeListToValueMap( values );
		    
		final Set<String>    getFailed  = new HashSet<String>();
		final Map<String,Object>    setFailed  = new HashMap<String,Object>();
		
        for ( final MBeanAttributeInfo attrInfo : attrInfos.values() )
        {
            final String    name    = attrInfo.getName();
            if ( ! valuesMap.keySet().contains( name ) )
            {
                getFailed.add( name );
                continue;
            }

            if ( attrInfo.isReadable() )
            {
                final Object    value   = valuesMap.get( name );

                if ( attrInfo.isWritable() )
                {
                    // set it to the same value as before
                    try
                    {
                        final Attribute attr    = new Attribute( name, value );
                        conn.setAttribute( objectName, attr );
                    }
                    catch( Exception e )
                    {
                        setFailed.put( name, value );
                    }
                }
            }
        }
        
        if ( getFailed.size() != 0 )
        {
            warning( "Could not get Attributes for " +
                StringUtil.quote( objectName ) + NEWLINE +
                 CollectionUtil.toString( getFailed, NEWLINE ) );
        }
        
        if ( setFailed.size() != 0 )
        {
            warning( "Could not identity-set Attributes for " +
                StringUtil.quote( objectName ) + NEWLINE +
                 MapUtil.toString( setFailed, NEWLINE ) );
        }
	}
	
	
		public void
	testGetSetAttributes()
	    throws Exception
	{
		final Set<AMX>	all = getAllAMX();
		
		for( final AMX amx : all )
		{
		    testGetSetAttributes( amx );
		}
	}
}
















