/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin/mbeanapi-impl/tests/com/sun/enterprise/management/config/ConfigMgrTestBase.java,v 1.7 2006/03/09 20:30:53 llc Exp $
 * $Revision: 1.7 $
 * $Date: 2006/03/09 20:30:53 $
 */
package com.sun.enterprise.management.config;

import java.util.Map;
import java.util.Collections;
import java.io.Serializable;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;

import javax.management.ObjectName;
import javax.management.AttributeList;
import javax.management.MBeanServerConnection;
import javax.management.Notification;
import javax.management.NotificationListener;

import com.sun.appserv.management.util.jmx.JMXUtil;
import com.sun.appserv.management.util.misc.ExceptionUtil;
import com.sun.appserv.management.util.misc.ClassUtil;
import com.sun.appserv.management.util.misc.MapUtil;

import com.sun.appserv.management.base.AMX;
import com.sun.appserv.management.base.Container;
import com.sun.appserv.management.base.Util;

import com.sun.appserv.management.config.AMXConfig;

import com.sun.appserv.management.client.ProxyFactory;


import com.sun.enterprise.management.AMXTestBase;
import com.sun.enterprise.management.Capabilities;
import com.sun.enterprise.management.CreateRemoveListener;

/**
 */
public abstract class ConfigMgrTestBase extends AMXTestBase
{
		protected
	ConfigMgrTestBase()
	{
		super();
	}
	
	
		protected String
	getProgenyTestName()
	{
		return( "test-" + ClassUtil.stripPackageName( this.getClass().getName() ) );
	}
	
	
	protected abstract AMXConfig	createProgeny(String name, Map<String,String> options );
	protected abstract Container	getProgenyContainer();
	protected abstract String		getProgenyJ2EEType();
	protected abstract void			removeProgeny( String name );
	
	protected static final Map<String,String>	ILLEGAL_OPTIONS	=
	    Collections.unmodifiableMap( MapUtil.newMap( new String[]
	{
		"IllegalParam1", "IllegalValue1",
		"IllegalParam2", "IllegalValue2",
	}));
	
		public final synchronized void
	testIllegalCreate() 
		throws Exception
	{
	    if ( ! checkNotOffline( "testIllegalCreate" ) )
	    {
	        return;
	    }
	    
		final String	name	= getProgenyTestName() + "-Illegal";
		
		try
		{
	    	final AMXConfig	proxy = createProgeny( name, ILLEGAL_OPTIONS );
	    	fail( "Expecting failure from createProgenyIllegal for progeny type: " + getProgenyJ2EEType() );
	    }
	    catch( Exception e )
	    {
	    	final Throwable rootCause	= ExceptionUtil.getRootCause( e );
	    	if ( ! ( rootCause instanceof IllegalArgumentException ) )
	    	{
	    		warning( "expecting IllegalArgumentException, got: " + rootCause.getClass().getName() +
	    		", msg = " + rootCause.getMessage() );
	    		rootCause.printStackTrace();
	    	}
	    }
	}
	
		public final synchronized void
	testCreateRemove() 
		throws Exception
	{
	    if ( ! checkNotOffline( "testCreateRemove" ) )
	    {
	        return;
	    }
	    
		final long	start	= now();
		
		String	name	= getProgenyTestName();
		
		final String	progenyJ2EEType	= getProgenyJ2EEType();
		
		AMXConfig	proxy	= getProgeny( name );
		if ( proxy != null )
		{
			final ObjectName	objectName	= Util.getExtra( proxy ).getObjectName();
			remove( name );
	   		waitUnregistered( objectName );
	   		assert( ! getConnection().isRegistered( objectName ) );
			assert( getProgeny( name ) == null );
			proxy	= null;
		}
		
		final Container	container	= getProgenyContainer();
		final CreateRemoveListener		listener	=
			new CreateRemoveListener( container, progenyJ2EEType, name );
		
		// create it
		try
		{
	        proxy = createProgeny( name, null );
	    }
	    catch( Exception e )
	    {
	        trace( getStackTrace( ExceptionUtil.getRootCause(e) ) );
	        failure( "Can't create item of j2eeType=" + progenyJ2EEType +
	            ",name=" + name );
	    }
	    assert( proxy.getName().equals( name ) );
		final ObjectName	objectName	= Util.getObjectName( proxy );
	    assert( getConnection().isRegistered( objectName ) );
	    assert( container.getContainee( progenyJ2EEType, name)  != null  );
	    assert( container.getContainee( progenyJ2EEType, name)  == proxy  );
	    final AMXConfig	progeny	= getProgeny( name );
	    assert( progeny == proxy );

		// remove it
		final ProxyFactory	factory	= Util.getExtra( proxy ).getProxyFactory();
		assert( name.equals( progeny.getName() ) );
	    remove( name );
	    waitUnregistered( objectName );
	    assert( ! getConnection().isRegistered( objectName ) );
	    waitProxyGone( factory, objectName );
		assert( getProgeny( name ) == null );
		
		listener.waitNotifs();
		
		printElapsed( "testCreateRemove: created/remove/listen for: " + progenyJ2EEType, start );
	}


		public AMXConfig
	getProgeny( final String name )
	{
		final Container	container	= getProgenyContainer();
		final String			progenyType	= getProgenyJ2EEType();
		
		//trace( "getProgeny: " + progenyType + "=" + name );
		final Object	progeny	= container.getContainee( progenyType, name );
		
		if ( progeny != null && ! (progeny instanceof AMXConfig) )
		{
			assert( progeny instanceof AMX );
			failure(
				"getProgeny: " + progenyType + "=" + name + " not an AMXConfig, interface = " +
				Util.getExtra( Util.asAMX(progeny )).getInterfaceName() );
		}
		
		return( (AMXConfig)progeny );
	}


    
		protected void
	remove( final String name) 
	{
		removeProgeny( name );
	}

	
		void
	removeEx(String name) 
	{
		final AMX	proxy	= getProgeny( name );
		if ( proxy != null )
		{
			assert( proxy.getName().equals( name )  );
			final ObjectName	objectName	= Util.getObjectName( proxy );
			
		    try
		    {
		    	remove(name);
		    
			    final MBeanServerConnection	conn	= getConnection();
			    while ( conn.isRegistered( objectName ) )
			    {
			    	trace( "waiting for mbean to be unregistered: " + objectName );
			    }
		    }
		    catch(Exception e)
		    {
		    	trace( "error removing MBean: " +
		    		objectName + " = " + ExceptionUtil.getRootCause( e ).getMessage() );
		    }
	    }
	    else
	    {
	    	// trace( "ConfigMgrTestBase.removeEx: " + name + " does not exist." );
	    }
	}
}


