/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.management.config;

import java.util.Set;
import java.util.Map;


import com.sun.appserv.management.helper.RefHelper;
import com.sun.appserv.management.base.Util;

import com.sun.appserv.management.config.*;


import com.sun.enterprise.management.AMXTestBase;
import com.sun.enterprise.management.Capabilities;



/**
    This test should normally be run before the generic tests
    so that it can set up default items for many of the config elements
    so that the generic tests will actually test them. Otherwise,
    when the generic tests are run, they won't see any instances
    of many of the AMXConfig MBeans.
    <p>
    If there are errors doing this, disable this test in amxtest.classes,
    fix the error in the specific place it's occurring, then re-enabled
    this test.
 */
public final class DanglingRefsTest extends AMXTestBase
{
		public
	DanglingRefsTest( )
	{
	}
	    public void
	testAllDangling()
	    throws ClassNotFoundException
	{
	    _testDanglingResourceRefConfigs();
	    //_testDanglingDeployedItemRefConfigs();
	}
	
	    private void
	_testDanglingResourceRefConfigs()
	    throws ClassNotFoundException
	{
	    final DomainConfig  domainConfig    = getDomainConfig();
	    final Set<ResourceConfig> resourcesSet    =
	        getQueryMgr().queryInterfaceSet( ResourceConfig.class.getName(), null );
	    
	    final Set<ResourceRefConfig>
	        refs = RefHelper.findAllResourceRefConfigs( getQueryMgr() );
	    
	    final Map<String,ResourceConfig>    resourcesMap    = Util.createNameMap( resourcesSet );
	    
	    for( final ResourceRefConfig ref : refs )
	    {
	        final String    name    = ref.getName();
	        
	        final ResourceConfig    resourceConfig  = resourcesMap.get( name );
	        if ( resourceConfig == null )
	        {
	            String msg    = 
	             "Resource reference '" +
	                Util.getObjectName( ref ) + "' refers to a non-existent resource";
	            
	            boolean removedOK   = false;
	            try
	            {
	               final ResourceRefConfigCR   container   =
	                    (ResourceRefConfigCR)ref.getContainer();
	                    
	               container.removeResourceRefConfig( name );
	               removedOK    = true;
	            }
	            catch( Exception e )
	            {
	                msg = msg + ", and trying to remove it throws an Exception " +
	                "(remove it manually from domain.xml)" +
	                ", see bug #6298512";
	            }
	            
	            if ( ! removedOK )
	            {
	                warning( msg );
	            }
	        }
	        else
	        {
	            //printVerbose( "ResourceRefConfig '" + name + "' is OK" );
	        }
	    }
	}
	
	/*
	   private void
	_testDanglingDeployedItemRefConfigs()
	    throws ClassNotFoundException
	{
	    final DomainConfig  domainConfig    = getDomainConfig();
	    
	    final Set<DeployedItemRefConfig> s    = (Set<DeployedItemRefConfig>)
	        getQueryMgr().queryInterfaceSet( DeployedItemRefConfig.class.getName(), null );
	    
	    final Set<DeployedItemRefConfig>
	        refs = RefHelper.findAllDeployedItemRefConfigRefs( getQueryMgr() );
	        
	    final Map<String,DeployedItem> deployedItemsMap    = Util.createNameMap( s );
	    
	    for( final DeployedItemRefConfig ref : refs )
	    {
	        final String    name    = ref.getName();
	        
	        final DeployedItem    deployedItem  = deployedItemsMap.get( name );
	        assert( deployedItem != null ) :
	            "Deployed item reference '" + Util.getObjectName( ref ) +
	                "' refers to a non-existent item";
	    }
	}
	*/
}

















