/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.management.config;

import java.util.Set;
import java.util.Map;
import java.util.Iterator;

import javax.management.ObjectName;

import com.sun.appserv.management.config.NamedConfigElement;
import com.sun.appserv.management.config.DomainConfig;

import com.sun.enterprise.management.AMXTestBase;
import com.sun.enterprise.management.Capabilities;
import com.sun.appserv.management.base.AMX;
import com.sun.appserv.management.config.*;

import com.sun.appserv.management.base.Util;


/**
 */
public final class DomainConfigTest extends AMXTestBase
{
		public
	DomainConfigTest()
	{
	}
	
		public void
	testGetDeployedItemProxies()
	{
		final DomainConfig	mgr	= getDomainConfig();
		
		final Set	proxies	= mgr.getContaineeSet();
		assert( proxies.size() != 0 );
		
		final Iterator	iter	= proxies.iterator();
		while ( iter.hasNext() )
		{
			final AMX	proxy	= Util.asAMX(iter.next());
		}
	}
	
		public void
	testGetDeployedItemProxiesByName()
	{
		final DomainConfig	mgr	= getDomainConfig();
		
		final Map<String,Map<String,AMX>>	typeMap	= mgr.getMultiContaineeMap( null );
		
		for( final String j2eeType : typeMap.keySet() )
		{
			final Map<String,AMX>	proxyMap	= typeMap.get( j2eeType );
			for( final String name : proxyMap.keySet() )
			{
				final AMX		amx	= Util.asAMX(proxyMap.get( name ));
				
				final AMX	proxy	= mgr.getContainee( j2eeType, name);
				
				assert( Util.getObjectName( proxy ).equals( Util.getObjectName( amx ) ) );
				assert( proxy.getName().equals( name ) );
			}
		}
	}
	
	
		public void
	testGetAttributes()
	{
		final DomainConfig	mgr	= getDomainConfig();
		
		mgr.getApplicationRoot();
		mgr.getLocale();
		mgr.getLogRoot();
	}
	
		private <T extends AMX> void
	checkMap( final Map<String,T> m )
	{
		assert( m != null );
		assert( ! m.keySet().contains( AMX.NO_NAME ) );
		assert( ! m.keySet().contains( AMX.NULL_NAME ) );
	}
	
	
		public void
	testGetMaps()
	{
		final DomainConfig	m	= getDomainConfig();
		
		checkMap( m.getServerConfigMap() );
		checkMap( m.getStandaloneServerConfigMap() );
		checkMap( m.getClusteredServerConfigMap() );
		checkMap( m.getLBConfigMap() );
		checkMap( m.getLoadBalancerConfigMap() );
		checkMap( m.getNodeAgentConfigMap() );
		checkMap( m.getConfigConfigMap() );
		checkMap( m.getClusterConfigMap() );
				
		checkMap( m.getPersistenceManagerFactoryResourceConfigMap() );
		checkMap( m.getJDBCResourceConfigMap() );
		checkMap( m.getJDBCConnectionPoolConfigMap() );
		checkMap( m.getConnectorResourceConfigMap() );
		checkMap( m.getConnectorConnectionPoolConfigMap() );
		checkMap( m.getAdminObjectResourceConfigMap() );
		checkMap( m.getResourceAdapterConfigMap() );
		checkMap( m.getMailResourceConfigMap() );
		
		checkMap( m.getJ2EEApplicationConfigMap() );
		checkMap( m.getEJBModuleConfigMap( ) );
		checkMap( m.getWebModuleConfigMap( ) );
		checkMap( m.getRARModuleConfigMap() );
		checkMap( m.getAppClientModuleConfigMap() );
		checkMap( m.getLifecycleModuleConfigMap() );	
	}
	
	/*
	    KEEP, not quite ready to test this yet.
	    public void
	testCreateStandaloneServerConfig()
	{
        final ConfigSetup setup  = new ConfigSetup( getDomainRoot() );
        
        setup.removeTestServer();
        
        final StandaloneServerConfig server = setup.createTestServer();
        setup.removeTestServer();
	}
	*/
	
	
	    public void
	testCreateClusterConfig()
	{
	    // to be done
	}
}



























