/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.management.config;

import java.util.Collections;
import java.util.Map;

import com.sun.appserv.management.base.Container;
import com.sun.appserv.management.base.XTypes;

import com.sun.appserv.management.config.AMXConfig;
import com.sun.appserv.management.config.DomainConfig;
import com.sun.appserv.management.config.PersistenceManagerFactoryResourceConfig;

/**
 */
public final class PersistenceManagerFactoryResourceConfigTest extends ResourceConfigTestBase
{
    public PersistenceManagerFactoryResourceConfigTest()
    {
	    if ( checkNotOffline( "ensureDefaultInstance" ) )
	    {
	        ensureDefaultInstance( getDomainConfig() );
	    }
    }
	
	     public static String
    getDefaultInstanceName()
    {
        return getDefaultInstanceName( "PersistenceManagerFactoryResourceConfig" );
    }
    
         public static PersistenceManagerFactoryResourceConfig
	ensureDefaultInstance( final DomainConfig dc )
	{
	    PersistenceManagerFactoryResourceConfig   result  =
	        dc.getPersistenceManagerFactoryResourceConfigMap().get( getDefaultInstanceName() );
	    
	    if ( result == null )
	    {
	        result  = createInstance( dc,
	            getDefaultInstanceName(),
	            null );
	    }
	    
	    return result;
	}
	
	    public static PersistenceManagerFactoryResourceConfig
	createInstance(
	    final DomainConfig  dc,
        final String    name,
        final Map<String,String> optional)
	{
	    return dc.createPersistenceManagerFactoryResourceConfig(
	            name, optional );
	}
	
	
	
		protected Container
	getProgenyContainer()
	{
		return getDomainConfig();
	}

		protected String
	getProgenyJ2EEType()
	{
		return XTypes.PERSISTENCE_MANAGER_FACTORY_RESOURCE_CONFIG;
	}


		protected void
	removeProgeny( final String name )
	{
		getDomainConfig().removePersistenceManagerFactoryResourceConfig( name );
	}
	
		protected final AMXConfig
	createProgeny(final String name, final Map<String,String> options )
	{
	    final PersistenceManagerFactoryResourceConfig	config	=
	    	getDomainConfig().createPersistenceManagerFactoryResourceConfig( name, options);
	    	
		addReference( config );
		
		return( config );
	}
}


