/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
package com.sun.enterprise.management.deploy;

import java.util.Map;
import java.util.HashMap;

import java.io.Serializable;

import com.sun.appserv.management.deploy.DeploymentStatus;
import com.sun.appserv.management.deploy.DeploymentStatusImpl;

import com.sun.appserv.management.base.MapCapable;

/**
	This implementation of Undeployer is a stub implementation designed
	to replace the normal implementation when unit tests are being run.
 */
final class Undeployer
{
	private final String	        mModuleID;
	private Map<String,String>		mParams;

	public Undeployer(final String moduleID, final Map<String,String> params)
	{
	    mModuleID	= moduleID;
	    mParams		= params;
	}

		public DeploymentStatus
	undeploy()
	{
		final Map<String,Serializable>	m	= new HashMap<String,Serializable>();
		m.put( MapCapable.MAP_CAPABLE_CLASS_NAME_KEY,
			DeploymentStatus.DEPLOYMENT_STATUS_CLASS_NAME);
			
		m.put( DeploymentStatus.STAGE_STATUS_KEY, new Integer( 0 ) );
		m.put( DeploymentStatus.STAGE_STATUS_MESSAGE_KEY, "stubbed dummy" );
		
	    return new DeploymentStatusImpl( m );
	}           
}

