/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin/mbeans/src/java/com/sun/enterprise/admin/dottedname/DottedNameLogger.java,v 1.3 2005/12/25 03:42:03 tcfujii Exp $
 * $Revision: 1.3 $
 * $Date: 2005/12/25 03:42:03 $
 */
package com.sun.enterprise.admin.dottedname;

import com.sun.logging.LogDomains;
import java.util.logging.Logger;

public final class DottedNameLogger
{
	static Logger		sLogger	= Logger.getLogger( LogDomains.ADMIN_LOGGER );
	
		private
	DottedNameLogger()
	{
	}
	
		public static Logger
	getInstance()
	{
		return( sLogger );
	}

		public static void
	dm( Object o )
	{
    	//sLogger.setLevel( java.util.logging.Level.INFO );
        sLogger.info( o == null ? "null" : o.toString() );
	}
	
		public static void
	logException( final Exception e )
	{
		if ( e instanceof DottedNameServerInfo.UnavailableException )
		{
			sLogger.severe( e.toString() );
		}
		else
		{
			sLogger.info( e.toString() );
		}
	}
}



