/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.admin.mbeans;
import com.sun.enterprise.server.pluggable.PluggableFeatureFactory;
import com.sun.logging.LogDomains;
import com.sun.enterprise.server.ApplicationServer;

import java.util.logging.Logger;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;


/**
 * This is called DiagnosticMBean because it is meant to aid the 
 * diagnostice services. In future this mBean is expected to provide 
 * more diagnostic service specific methods.
 *
 * @author Sreenivas Munnangi
 */

public class DomainDiagnostics implements DomainDiagnosticsMBean {

    protected Logger _logger = LogDomains.getLogger(LogDomains.ADMIN_LOGGER);
    /*protected static final StringManager _strMgr = 
            StringManager.getManager(DomainDiagnostics.class);*/
    private PluggableFeatureFactory featureFactory;
    /**
     * default constructor
     */
    public DomainDiagnostics() {
            initPluggableFeatureFactory();
    }

    /**
     * get DAS diagnostic report
     */
    public String generateReport(Map input) throws  Exception {
        if(input != null) {
            if(featureFactory != null) {
                com.sun.enterprise.diagnostics.DiagnosticAgent agent = 
                        featureFactory.getDiagnosticAgent();
                 return agent.generateReport(input);
            }
            throw new Exception("Unable to retrieve feature factory");
        }
        throw new Exception(" Null input");
    }
            

    /**
     * @param repositoryDir absolute path of central repository
     * @return list of attributes being masked with ****
     * @throw DiagnosticException 
     */
    public List<String> getConfidentialProperties() 
    throws  Exception {
        if(featureFactory != null) {
            com.sun.enterprise.diagnostics.DiagnosticAgent agent = 
                        featureFactory.getDiagnosticAgent();
            String repositoryDir =  ApplicationServer.getServerContext().
                    getInstanceEnvironment().getInstancesRoot();
            return agent.getConfidentialProperties(repositoryDir);    
        }
        throw new Exception(" Unable to retrive Pluggable Feature Factory");
    }
    
   
    private void initPluggableFeatureFactory() {
        featureFactory = 
                ApplicationServer.getServerContext().getPluggableFeatureFactory();
        if (featureFactory == null) {
            _logger.log(Level.WARNING,
                    "diagnostic-service.error_initalize_pluggable_factory");
        }
    }
}
