/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.admin.servermgmt;

import com.sun.enterprise.util.i18n.StringManager;

/**
 * Validator class for domain config entries whose type is java.lang.String.
 */
public class StringValidator extends Validator
{
    /**
     * i18n strings manager object
     */
    private static final StringManager strMgr = 
        StringManager.getManager(StringValidator.class);

    /**
     * Constructs new StringValidator object.
     * @param name
     */
    public StringValidator(String name)
    {
        super(name, java.lang.String.class);
    }

    /**
     * Validates the given value for the given entry. This method first invokes
     * its superclass's validate method and then checks additional string 
     * validations such as 0 length.
     * @throws InvalidConfigException
     */
    public void validate(Object str) throws InvalidConfigException
    {
        super.validate(str);
        int length = ((String)str).length();
        if (length == 0)
        {
            throw new InvalidConfigException(
                strMgr.getString("validator.invalid_value", getName(), str));
        }
    }
}
