/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.admin.servermgmt.pe;

public final class InstanceTimer implements Runnable
{
    private final   int             timeOutSeconds;
    private final   TimerCallback   callBack;
    private final   int             startAfterSeconds;
    private boolean                 timeOutReached;
    private long                    startTime;

    public InstanceTimer(int timeOutSeconds,
                  int startAfterSeconds,
                  TimerCallback callBack)
    {
        this.timeOutSeconds     = timeOutSeconds;
        this.startAfterSeconds  = startAfterSeconds;
        this.callBack           = callBack;
        this.timeOutReached     = false;
    }

    public void run()
    {
        startTime = System.currentTimeMillis();
        try
        {
            Thread.currentThread().sleep(startAfterSeconds * 1000);
            while (!timeOutReached() && !callBack.check())
            {
                try
                {
                    Thread.currentThread().sleep(1000);
                    computeTimeOut();
                }
                catch (InterruptedException ie)
                {
                    //sLogger.warning(ie.toString());
                    timeOutReached = true;
                }
            }
        }
        catch (Exception e)
        {
            //sLogger.warning(e.toString());
            timeOutReached = true;
        }
    }

    private boolean timeOutReached()
    {
        return timeOutReached;
    }

    private void computeTimeOut()
    {
        long currentTime = System.currentTimeMillis();
        timeOutReached =
            ((currentTime - startTime) >= (timeOutSeconds * 1000));
    }
}