/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.admin.servermgmt.pe;

import java.io.File;

import com.sun.enterprise.admin.util.TokenValue;
import com.sun.enterprise.admin.util.TokenValueSet;
import com.sun.enterprise.admin.servermgmt.DomainConfig;
import com.sun.enterprise.admin.servermgmt.pe.PEFileLayout;

/**
 * This class defines the tokens required by the startserv & stopserv scripts.
 */
public final class PEScriptsTokens
{
    public static final String CONFIG_HOME = "CONFIG_HOME";
    public static final String INSTANCE_ROOT = "INSTANCE_ROOT";
    public static final String SERVER_NAME = "SERVER_NAME";
    public static final String DOMAIN_NAME = "DOMAIN_NAME";

    /**
     * @return Returns the TokenValueSet that has the (token, value) pairs for
     * startserv & stopserv scripts.     
     * @param domainConfig
     */
    public static TokenValueSet getTokenValueSet(DomainConfig domainConfig)
    {
        final PEFileLayout layout = new PEFileLayout(domainConfig);

        final TokenValueSet tokens = new TokenValueSet();

        final String configRootDir = domainConfig.getConfigRoot();            
        TokenValue tv = new TokenValue(CONFIG_HOME, configRootDir);
        tokens.add(tv);

        final String instanceRoot = 
            layout.getRepositoryDir().getAbsolutePath();
        tv = new TokenValue(INSTANCE_ROOT, instanceRoot);
        tokens.add(tv);

        final String instanceName = (String)domainConfig.get(DomainConfig.K_SERVERID);
        if((instanceName == null) || (instanceName.equals("")))
            tv = new TokenValue(SERVER_NAME, PEFileLayout.DEFAULT_INSTANCE_NAME);
        else
            tv = new TokenValue(SERVER_NAME, instanceName);
        tokens.add(tv);

        tv = new TokenValue(DOMAIN_NAME, domainConfig.getDomainName());
        tokens.add(tv);

        return ( tokens );
    }
}
