/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the "License").  You may not use this file except 
 * in compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt or 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html. 
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * HEADER in each file and include the License file at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable, 
 * add the following below this CDDL HEADER, with the 
 * fields enclosed by brackets "[]" replaced with your 
 * own identifying information: Portions Copyright [yyyy] 
 * [name of copyright owner]
 */

package com.sun.enterprise.config.serverbeans.validation.tests;

import com.sun.enterprise.config.serverbeans.validation.GenericValidator;
import com.sun.enterprise.config.serverbeans.validation.ValidationDescriptor;
import com.sun.enterprise.config.serverbeans.validation.ValidationContext;
import com.sun.enterprise.config.serverbeans.validation.AttrType;
import com.sun.enterprise.config.serverbeans.validation.AttrString;
import com.sun.enterprise.config.serverbeans.validation.Result;

import com.sun.enterprise.config.serverbeans.J2eeApplication;

import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigContextEvent;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.ManagementRule;
import com.sun.enterprise.config.serverbeans.Event;
import java.util.logging.Level;
import java.util.Arrays;
import java.util.List;

public class ManagementRuleTest extends GenericValidator {
    
    public ManagementRuleTest(ValidationDescriptor desc) {
        super(desc);
    } 
    
    final static List EVENT_TYPES=
         Arrays.asList("log","timer","trace","monitor","cluster", "lifecycle","notification");
    final static List LOG_LEVELS=
         Arrays.asList("FINEST","FINER","FINE","CONFIG","INFO","WARNING","SEVERE","OFF");
    
    public void validateElement(ValidationContext valCtx) 
    {
         super.validateElement(valCtx);
         
         // this is temporaty code which should be removed after
         // "deep" childs validation will be implemented for add/set operations
         if( (valCtx.isADD() || valCtx.isSET()) && 
             valCtx.value instanceof ManagementRule)
         {
             try {
                Event event = ((ManagementRule)valCtx.value).getEvent();
                //eventtypes
                if(!EVENT_TYPES.contains(event.getType()))
                    valCtx.result.failed(smh.getLocalString(getClass().getName(),
                            valCtx.smh.getLocalString(getClass().getName() + ".wrongEventType",
                "Value {0} is not allowed for Event type", new Object[] {event.getType()})));
                //log-levels
                if(!LOG_LEVELS.contains(event.getLevel()))
                    valCtx.result.failed(smh.getLocalString(getClass().getName(),
                            valCtx.smh.getLocalString(getClass().getName() + ".wrongEventLevel",
                "Value {0} is not allowed for Event log level", new Object[] {event.getLevel()})));
             } catch (Exception e) {}
             
         }
    }
    

}
