/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.admin.wsmgmt.config.spi;

/**
 * This represents transformation rule for a web service end point. 
 */
public interface TransformationRule {

    /**
     * Returns the name of the transformation rule
     *
     * @return the name of the transformation rule
     */
    public String getName();

    /**
     * Returns true, if this transformation rule is enabled
     *
     * @return true, if this transformation rule is enabled
     */
    public boolean getEnabled();
    
    /**
     * Returns the value of "Apply-to" attribute
     *
     * @return the value of "Apply-to" attribute
     */
    public String getApplyTo();

    /**
     * Returns the location of rule file 
     *
     * @return the location of rule file
     */
    public String getRuleFileLocation();
}
