/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.admin.wsmgmt.transform;

import com.sun.enterprise.admin.wsmgmt.config.spi.WebServiceConfig;

import java.util.logging.Logger;
import java.util.logging.Level;
import com.sun.logging.LogDomains;
import com.sun.enterprise.util.i18n.StringManager;

/**
 *  Transformation initialization and cleanup facilitator
 */
public class TransformMgr {

    /**
     * Returns the singleton instance of this class. 
     *
     * @return  singleton instance of this class
     */
    public static TransformMgr getInstance() {
        if (_instance == null) {
            _instance = new TransformMgr();
        }

        return _instance;
    }

    /**
     * Private constructor.
     */
    private TransformMgr() {
    } 

    /**
     * Initializes the transformation capability for an endpoint.
     */
    public void init(String appId, WebServiceConfig wsc) {
        if ( wsc == null) {
            return;
        }

        try {
            // if there is atleast one transformation register a filter
             if ((wsc.getRequestTransformationRule() != null) ||
              (wsc.getResponseTransformationRule() != null)) {
                TransformHandler tHandler = new TransformHandler(wsc, appId);
                tHandler.registerFilter(wsc);
            }

        } catch (Exception e) {
            String msg="Configuration initialization error.";
            _logger.log(Level.FINE, msg, e);
        }
    }

    /**
     * Shuts down transformation capabilities for an endpoint
     */
    public void stop(String appId, WebServiceConfig wsc) {
        if ( wsc == null) {
            return;
        }

        try {
            // if there is atleast one transformation register a filter
             if ((wsc.getRequestTransformationRule() != null) ||
              (wsc.getResponseTransformationRule() != null)) {
                TransformHandler tHandler = new TransformHandler(wsc, appId);
                tHandler.unregisterFilter(appId,wsc);
            }

        } catch (Exception e) {
            String msg="Configuration initialization error.";
            _logger.log(Level.FINE, msg, e);
        }
    }

    // ---- VARIABLES - PRIVATE ---------------------------------------
    private static TransformMgr _instance = null;
    private static final Logger _logger = 
        Logger.getLogger(LogDomains.ADMIN_LOGGER);
    private static final StringManager _stringMgr = 
        StringManager.getManager(TransformMgr.class);

}
