/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.deployment.annotation;

import java.lang.annotation.Annotation;

/**
 * This interface defines the contract for annotation handlers 
 * and the annotation processing engine. Each annotation handler
 * is registered for a particular annotation type and will be 
 * called by the engine when such annotation type is encountered.
 *
 * The AnnotationHandler is a stateless object, no state should 
 * be stored, instead users should use the ProcessingContext.
 *
 * Annotation can be defined or processed in random orders on a 
 * particular type, however, a particular annotation may need 
 * other annotation to be processed before itself in order to be 
 * processed successfully. An annotation type can indicate through
 * the @see getAnnotations() method which annotation types should 
 * be processed before itself.
 *
 * @author Jerome Dochez
 */
public interface AnnotationHandler {
    
    /**
     * @return the annoation type this annotation handler is handling
     */
    public Class<? extends Annotation> getAnnotationType();
    
    /**
     * Process a particular annotation which type is the same as the 
     * one returned by @see getAnnotationType(). All information 
     * pertinent to the annotation and its context is encapsulated 
     * in the passed AnnotationInfo instance.
     * 
     * @param element the annotation information
     */
    public HandlerProcessingResult processAnnotation(AnnotationInfo element)
        throws AnnotationProcessorException;
    
    /**
     * @return an array of annotation types this annotation handler would 
     * require to be processed (if present) before it processes it's own 
     * annotation type.
     */
    public Class<? extends Annotation>[] getTypeDependencies();
        
}
