/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.deployment.annotation;

import java.util.Set;

/** 
 * This interface is responsible for scanning the binary location 
 * provided and provide each binary file through a pull interfaces
 *
 * @author Jerome Dochez
 */
public interface Scanner {
    
    /**
     * Returns a ClassLoader capable of loading classes from the 
     * underlying medium
     * @return a class loader capable of loading the classes
     */
    public ClassLoader getClassLoader();
    
    /**
     * Return a complete set of classes available from this location.
     * @return the complete set of classes 
     */
    public Set<Class> getElements();
    
    /**
     * Sometimes, annotations processing requires more than a single class, 
     * especially when such classes end up being a Java Component (Java Beans, 
     * Java EE). The implementation returned from the getComponent will be 
     * responsible for defining the complete view of this component starting 
     * from it's implementation class.
     * @param implementation class of the component.
     */
    public ComponentInfo getComponentInfo(Class componentImpl);
    
}
