/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/**
 * PROPRIETARY/CONFIDENTIAL.  Use of this product is subject to license terms.
 *
 * Copyright 2001-2002 by iPlanet/Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 */
package com.sun.enterprise.config.impl;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Set;
import java.util.Iterator;

/**
 * A configuration change for an element. Holds xpath, list of changed 
 * attributes, their old and new values.
 */
public class ConfigSetImpl extends ConfigChangeImpl implements com.sun.enterprise.config.ConfigSet, Serializable {

    private Object cb;
    private Object[] cbArray; // PS: will have one of this.
    
    private String name;

    public String getConfigChangeType() {
        return TYPE_SET;
    }
    
    public ConfigSetImpl(String parentXpath, String name, Object cb, Object[] cbArray) {
        this.parentXpath = parentXpath;
        this.xpath = parentXpath; // temporarily add this to xpath also 
                                  // since it is being used in notification
        this.cb = cb;
        this.cbArray = cbArray;
        this.name = name;
    }        
    
    public Object getConfigBean() {
        return cb;
    }
    
    public Object[] getConfigBeanArray() {
        return cbArray;
    }
    public String getName() {
        return name;
    }
    
    public String toString() {
        String s = (cb == null) ? "" : cb.toString();
        String ret = s + ":set parentXpath=" + parentXpath +"\n";
        return ret;
    }
}
