/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.web.SecurityRole;
import com.sun.enterprise.deployment.web.AuthorizationConstraint;

import java.util.Enumeration;
import java.util.Vector;
import java.util.HashSet;
import java.util.Set;

/**
 * This descriptor represents an authorization contraint on a security 
 * constraint in a web application.
 *
 * @author Danny Coward
 */

public class AuthorizationConstraintImpl extends Descriptor implements 
		AuthorizationConstraint {
    private Set securityRoles;
    
    /** 
     * Default constructor that creates an AuthorizationConstraint 
     * with no roles.
     */
    public AuthorizationConstraintImpl() {
    }
    
    /**
     * Copy constructor.
     */
    public AuthorizationConstraintImpl(AuthorizationConstraintImpl other) {
	this.securityRoles = new HashSet(other.getSecurityRoleSet());
    }
    
    /**
     * Return the set of roles.
     */
    private Set getSecurityRoleSet() {
	if (this.securityRoles == null) {
	    this.securityRoles = new HashSet();
	}
	return this.securityRoles;
    }

    /** 
     * Return the security roles involved in this constraint. The 
     * enumeration is empty if there are none.
     * @return the enumeration of security roles in this constraint.
     */
    public Enumeration getSecurityRoles() {
	if (this.securityRoles == null) {
	    this.securityRoles = new HashSet();
	}
	return (new Vector(this.getSecurityRoleSet())).elements();
    }
    
    /**
     * Adds a role to the authorization constraint.
     * @param the role to be added.
     */
    public void addSecurityRole(SecurityRole securityRole) {
	this.getSecurityRoleSet().add(securityRole);
    }
    
    /**
     * Adds a role to the authorization constraint
     * @param the role name to be added
     */ 
    public void addSecurityRole(String roleName) {
        SecurityRoleDescriptor sr = new SecurityRoleDescriptor();
        sr.setName(roleName);
        addSecurityRole(sr);
    }
    
    /**
     * Removes the given role from the autrhorization constraint.
     * @param the role to be removed.
     */
    public void removeSecurityRole(SecurityRole securityRole) {
	this.getSecurityRoleSet().remove(securityRole);
    }

    /**
     * Prints a formatted representation of this object.
     */
    public void print(StringBuffer toStringBuffer) {
	toStringBuffer.append("AuthorizationConstraint ");
	super.print(toStringBuffer);
	toStringBuffer.append(" securityRoles ").append(this.securityRoles);
    }
    
}
