/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * @(#) DescriptorConstants.java
 *
 * Copyright 2000-2001 by iPlanet/Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of iPlanet/Sun Microsystems, Inc. ("Confidential Information").
 * You shall not disclose such Confidential Information and shall
 * use it only in accordance with the terms of the license
 * agreement you entered into with iPlanet/Sun Microsystems.
 */
package com.sun.enterprise.deployment;

import java.io.File;

/**
 * Contains all deployment descriptor constants.
 *
 * @author Nazrul Islam
 * @since  JDK1.4
 */
public interface DescriptorConstants {

    /**
     * Bean Pool - maximum size, a pool of slsb can grow to.
     */ 
    int MAX_POOL_SIZE_DEFAULT = -1;
    
    /**
     * Bean Pool - maximum time a caller will have to wait when pool 
     * has reached maximum configured size and an instance is not 
     * available to process the incoming request.
     */ 
    int MAX_WAIT_TIME_DEFAULT = -1;
    
    /**
     * Bean Pool - size of slsb pool grows in increments specified by 
     * resize-quantity, within the configured upper limit max-pool-size. 
     */
    int POOL_RESIZE_QTY_DEFAULT = -1;
    
    /**
     * Bean Pool - minimum number of slsb instances maintained in a pool.
     */ 
    int STEADY_POOL_SIZE_DEFAULT = -1;   
    
    /**
     * Bean Pool - idle bean instance in a pool becomes a candidate for 
     * passivation (sfsb/eb) or deletion (slsb), when this timeout expires.
     */ 
    int POOL_IDLE_TIMEOUT_DEFAULT = -1;
    
    /**
     * Bean Cache - sfsb and eb are created and cached, on demand.
     */     
    int MAX_CACHE_SIZE_DEFAULT = -1;
    
    /**
     * Bean Cache - resize quantity
     */     
    int RESIZE_QUANTITY_DEFAULT = -1;
    
    /**
     * Bean Cache - Passivated bean (sfsb/eb) instance is removed if it 
     * is not accesed within  this time, after passivation
     */
    int REMOVAL_TIMEOUT_DEFAULT = -1;   
    
    /**
     * Bean Cache - idle bean instance in a pool becomes a candidate for 
     * passivation (sfsb/eb) or deletion (slsb), when this timeout expires.
     */
    int CACHE_IDLE_TIMEOUT_DEFAULT = -1;
    
    /**
     * ejb - refresh period in seconds
     */
    int REFRESH_PERIOD_IN_SECONDS_DEFAULT = -1;
}
