/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 package com.sun.enterprise.deployment;

    /**
    * Objects implementing this interface have a JNDI
    ** name property.
    * 
    *@author Danny Coward
    */

public interface NamedDescriptor {

    /**
    * The name of this descriptor.
    *
     * @return java.lang.String name
     */
    public String getName();

     /** 
     * Returns the JNDI name property of the receiver.
     *
     * @return java.lang.String JNDI name
     */

    public String getJndiName();
    
    /**  
     * Sets the JNDI name property of the reciever as a String.
     *   
     * @param jndiName the new JNDI name of the receiver.  
     *
     */
    public void setJndiName(String jndiName);
    
}
