/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.deployment;

import java.util.*;

    /** I am an ordered collection that does not allow duplicates.
    *
    * @author Danny Coward
    */

class OrderedSet extends Vector implements Set {
    
	/** Construct an empty collection.
	*/
	public OrderedSet() {
	}

	/** Construct an ordered set from the given collection.
	*/
	public OrderedSet(Collection c) {
	    this();
	    this.addAll(c);
	}

	/** 
	* Add the given object to the Set if it is not equal (equals()) to
	* an element already in the set.
	*/
	public boolean add(Object o) {
	    if (o != null && !this.contains(o)) {
		return super.add(o);
	    }
	    return false;
	}
	
	/**
	* Add all the elements in the given set that are not already
	* in this ordered set.
	*/
	public boolean addAll(Collection c) {
	    boolean setChanged = false;
	    if (c != null) {
		for (Iterator itr = c.iterator(); itr.hasNext();) {
		    if (this.add(itr.next())) {
			setChanged = true;
		    }
		}
	    }
	    return setChanged;
	}
	
    }
