/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * EjbRelationRole.java
 *
 * Created on February 1, 2002, 3:07 PM
 */

package com.sun.enterprise.deployment.node.ejb;

import java.util.Map;
import org.w3c.dom.Node;

import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.node.DeploymentDescriptorNode;
import com.sun.enterprise.deployment.node.LocalizedInfoNode;
import com.sun.enterprise.deployment.node.DescriptorFactory;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.RelationRoleDescriptor;
import com.sun.enterprise.deployment.RelationshipDescriptor;
import com.sun.enterprise.deployment.xml.EjbTagNames;

/**
 *
 * @author  dochez
 * @version 
 */
public class EjbRelationNode extends DeploymentDescriptorNode {

    RelationRoleDescriptor source = null;
    RelationRoleDescriptor sink = null;
    RelationshipDescriptor descriptor = null; 
    
    public EjbRelationNode() {
       super();
       registerElementHandler(new XMLElement(EjbTagNames.EJB_RELATIONSHIP_ROLE),
                                                            EjbRelationshipRoleNode.class);                   
    }
        
   /**
    * @return the descriptor instance to associate with this XMLNode
    */    
    public Object getDescriptor() {
        if (descriptor==null) {
            descriptor = (RelationshipDescriptor) DescriptorFactory.getDescriptor(getXMLPath());
        } 
        return descriptor;
    }        
    
    /**
     * Adds  a new DOL descriptor instance to the descriptor instance associated with 
     * this XMLNode
     *
     * @param descriptor the new descriptor
     */
    public void addDescriptor(Object newDescriptor) {
        if (newDescriptor instanceof RelationRoleDescriptor) {
            if (source==null) {
                source = (RelationRoleDescriptor) newDescriptor;
            } else {
                sink = (RelationRoleDescriptor) newDescriptor;
                
                descriptor.setSource(source);
                source.setPartner(sink);
                source.setRelationshipDescriptor(descriptor);
                descriptor.setSink(sink);
                sink.setPartner(source);
                sink.setRelationshipDescriptor(descriptor);

                if ( source.getCMRField() != null && sink.getCMRField() != null )
                    descriptor.setIsBidirectional(true);
                else
                    descriptor.setIsBidirectional(false);                
            }
        }
    }
        
    /**
     * all sub-implementation of this class can use a dispatch table to map xml element to
     * method name on the descriptor class for setting the element value. 
     *  
     * @return the map with the element name as a key, the setter method as a value
     */    
    protected Map getDispatchTable() {
        // no need to be synchronized for now
        Map table = super.getDispatchTable();
        table.put(EjbTagNames.EJB_RELATION_NAME, "setName");
        return table;
    }    

   /**
     * write the relationships descriptor class to a DOM tree and return it
     *
     * @param parent node in the DOM tree 
     * @param node name for the root element of this xml fragment      
     * @param the descriptor to write
     * @return the DOM tree top node
     */
    public Node writeDescriptor(Node parent, String nodeName, RelationshipDescriptor descriptor) {
        Node ejbRelationNode = super.writeDescriptor(parent, nodeName, descriptor);        
        writeLocalizedDescriptions(ejbRelationNode, descriptor);
        appendTextChild(ejbRelationNode, EjbTagNames.EJB_RELATION_NAME, descriptor.getName());     
        EjbRelationshipRoleNode roleNode = new EjbRelationshipRoleNode();
        roleNode.writeDescriptor(ejbRelationNode, EjbTagNames.EJB_RELATIONSHIP_ROLE, descriptor.getSource());
        roleNode.writeDescriptor(ejbRelationNode, EjbTagNames.EJB_RELATIONSHIP_ROLE, descriptor.getSink());
        return ejbRelationNode;
    }
}
