/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.deployment.node.runtime.connector;

import java.util.Map;
import org.w3c.dom.Node;
import org.w3c.dom.Element;

import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.node.runtime.RuntimeDescriptorNode;
import com.sun.enterprise.deployment.runtime.connector.Principal;
import com.sun.enterprise.deployment.runtime.RuntimeDescriptor;
import com.sun.enterprise.deployment.xml.RuntimeTagNames;

/**
 * This node handles the principal runtime deployment descriptors 
 *
 * @author  Jerome Dochez
 * @version 
 */
public class PrincipalNode extends RuntimeDescriptorNode {
    
    /**
     * receives notification of the value for a particular tag
     * 
     * @param element the xml element
     * @param value it's associated value
     */
    public void setElementValue(XMLElement element, String value) {    
	RuntimeDescriptor descriptor = (RuntimeDescriptor) getDescriptor();
	if (descriptor==null) {
	    throw new RuntimeException("Trying to set values on a null descriptor");
	}
	if (element.getQName().equals(RuntimeTagNames.USER_NAME)) {
	    descriptor.setAttributeValue(Principal.USER_NAME, value);
	} else
	if (element.getQName().equals(RuntimeTagNames.PASSWORD)) {
	    descriptor.setAttributeValue(Principal.PASSWORD, value);
	} else
	if (element.getQName().equals(RuntimeTagNames.CREDENTIAL)) {
	    descriptor.setAttributeValue(Principal.CREDENTIAL, value);
	} else
	super.setElementValue(element, value);
    }	
	
    
    /**
     * write the descriptor class to a DOM tree and return it
     *
     * @param parent node for the DOM tree
     * @param node name for the descriptor
     * @param the descriptor to write
     * @return the DOM tree top node
     */    
    public Node writeDescriptor(Node parent, String nodeName, Principal descriptor) {
	Element principalNode = (Element) super.writeDescriptor(parent, nodeName, descriptor);
	appendTextChild(principalNode, RuntimeTagNames.DESCRIPTION, descriptor.getDescription());
	setAttribute(principalNode, RuntimeTagNames.USER_NAME, (String) descriptor.getValue(Principal.USER_NAME));
	setAttribute(principalNode, RuntimeTagNames.PASSWORD, (String) descriptor.getValue(Principal.PASSWORD));
	setAttribute(principalNode, RuntimeTagNames.CREDENTIAL, (String) descriptor.getValue(Principal.CREDENTIAL));
	return principalNode;
    }
}
