/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.deployment.node.runtime.web;

import java.util.Map;
import org.w3c.dom.Node;
import org.w3c.dom.Element;

import com.sun.enterprise.deployment.runtime.RuntimeDescriptor;
import com.sun.enterprise.deployment.runtime.web.CacheHelper;
import com.sun.enterprise.deployment.runtime.web.WebProperty;
import com.sun.enterprise.deployment.xml.RuntimeTagNames;
import com.sun.enterprise.deployment.node.XMLElement;

/**
* node for cache-helper tag
*
* @author Jerome Dochez
*/
public class CacheHelperNode extends WebRuntimeNode {
    
    public CacheHelperNode() {
	
        registerElementHandler(new XMLElement(RuntimeTagNames.PROPERTY), 
                               WebPropertyNode.class, "addWebProperty"); 			       
    }

    /**
     * parsed an attribute of an element
     *
     * @param the element name
     * @param the attribute name
     * @param the attribute value
     * @return true if the attribute was processed
     */
    protected boolean setAttributeValue(XMLElement elementName, XMLElement attributeName, String value) {
	RuntimeDescriptor descriptor = (RuntimeDescriptor) getRuntimeDescriptor();
	if (descriptor==null) {
	    throw new RuntimeException("Trying to set values on a null descriptor");
	} 	
	if (attributeName.getQName().equals(RuntimeTagNames.NAME)) {
	    descriptor.setAttributeValue(CacheHelper.NAME, value);
	    return true;
	} else
	if (attributeName.getQName().equals(RuntimeTagNames.CLASS_NAME)) {
	    descriptor.setAttributeValue(CacheHelper.CLASS_NAME, value);
	    return true;
	}  
	return false;
    }
    
    /**
     * write the descriptor class to a DOM tree and return it
     *
     * @param parent node for the DOM tree
     * @param node name 
     * @param the descriptor to write
     * @return the DOM tree top node
     */    
    public Node writeDescriptor(Node parent, String nodeName, CacheHelper descriptor) {    

	Element cacheHelper = (Element) super.writeDescriptor(parent, nodeName, descriptor);
	
	// property*
	WebProperty[] properties = descriptor.getWebProperty();
	if (properties.length>0) {
	    WebPropertyNode wpn = new WebPropertyNode();
	    wpn.writeDescriptor(cacheHelper, RuntimeTagNames.PROPERTY, properties);
	}
	
	// name, class-name attribute
	setAttribute(cacheHelper, RuntimeTagNames.NAME, (String) descriptor.getAttributeValue(CacheHelper.NAME));
	setAttribute(cacheHelper, RuntimeTagNames.CLASS_NAME, (String) descriptor.getAttributeValue(CacheHelper.CLASS_NAME));
	
	return cacheHelper;
    }
}
