/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.deployment.runtime.web;

import com.sun.enterprise.deployment.runtime.RuntimeDescriptor;

/**
* this class contains runtime information for the web bundle 
* it was kept to be backward compatible with the schema2beans descriptors
* generated by iAS 7.0 engineering team.
*
* @author Jerome Dochez
*/
public class SessionConfig extends RuntimeDescriptor
{
    
    static public final String SESSION_MANAGER = "SessionManager";	// NOI18N
    static public final String SESSION_PROPERTIES = "SessionProperties";	// NOI18N
    static public final String COOKIE_PROPERTIES = "CookieProperties";	// NOI18N
    
    // This attribute is optional
    public void setSessionManager(SessionManager value)
    {
	this.setValue(SESSION_MANAGER, value);
    }
    
    //
    public SessionManager getSessionManager()
    {
	return (SessionManager)this.getValue(SESSION_MANAGER);
    }
    
    // This attribute is optional
    public void setSessionProperties(SessionProperties value)
    {
	this.setValue(SESSION_PROPERTIES, value);
    }
    
    //
    public SessionProperties getSessionProperties()
    {
	return (SessionProperties)this.getValue(SESSION_PROPERTIES);
    }
    
    // This attribute is optional
    public void setCookieProperties(CookieProperties value)
    {
	this.setValue(COOKIE_PROPERTIES, value);
    }
    
    //
    public CookieProperties getCookieProperties()
    {
	return (CookieProperties)this.getValue(COOKIE_PROPERTIES);
    }
    
    // This method verifies that the mandatory properties are set
    public boolean verify()
    {
	return true;
    }
    
}
