/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */


package com.sun.enterprise.deployment.types;

import java.util.Set;

/**
 * This interface defines the behaviour of a J2EE component containaing ejb
 * references
 *
 * @author Jerome Dochez
 * @version 
 */
public interface EjbReferenceContainer {

    /**
     * Add a reference to an ejb.
     * 
     * @param the ejb reference
     */
    public void addEjbReferenceDescriptor(EjbReference ejbReference);
    
    /**
     * Looks up an ejb reference with the given name. Throws an IllegalArgumentException
     * if it is not found.
     *
     * @param the name of the ejb-reference
     */
    public EjbReference getEjbReference(String name);
    
    /**
     * Return the set of references to ejbs that I have.
     */
    public Set getEjbReferenceDescriptors();
}

