/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * ComponentVisitor.java
 *
 * Created on January 31, 2002, 11:29 AM
 */

package com.sun.enterprise.deployment.util;

import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.InjectionCapable;
import com.sun.enterprise.deployment.JmsDestinationReferenceDescriptor;
import com.sun.enterprise.deployment.MessageDestinationDescriptor;
import com.sun.enterprise.deployment.MessageDestinationReferenceDescriptor;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.deployment.RoleReference;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.deployment.types.EjbReference;
import com.sun.enterprise.deployment.types.MessageDestinationReferencer;

/**
 * This class defines the protocol for visiting J2EE Component DOL  
 * related classes 
 *
 * @author  Jerome Dochez
 * @version 
 */
public interface ComponentVisitor extends DescriptorVisitor {

   /**
     * visits all entries within the component environment for which
     * isInjectable() == true
     * @param the InjectionCapable environment dependency
     */
    public void accept(InjectionCapable injectable);
    

   /**
     * visits an ejb reference for the last J2EE component visited
     * @param the ejb reference
     */
    public void accept(EjbReference ejbRef);
    
    /**
     * visits a role reference from the last  J2EE component visited
     * @param role reference
     */
    public void accept(RoleReference roleRef);
    
    /**
     * visits an environment property  for the last J2EE component visited
     * @param the environment property
     */
    public void accept(EnvironmentProperty envEntry);    

    /**
     * visits an resource reference for the last J2EE component visited
     * @param the resource reference
     */
    public void accept(ResourceReferenceDescriptor resRef);

    /**
     * visits an jms destination reference for the last J2EE component visited
     * @param the jms destination reference
     */
    public void accept(JmsDestinationReferenceDescriptor jmsDestRef);

    /**
     * visits an message destination reference for the last J2EE component visited
     * @param the message destination reference
     */
    public void accept(MessageDestinationReferenceDescriptor msgDestRef);

    /**
     * visits an message destination for the last J2EE component visited
     * @param the message destination
     */
    public void accept(MessageDestinationDescriptor msgDest);

    /**
     * visits a message destination referencer for the last J2EE component
     * visited.
     */
    public void accept(MessageDestinationReferencer msgDestReferencer);

    /**
     * visits a service reference for the last J2EE component visited.
     */
    public void accept(ServiceReferenceDescriptor serviceRef);
}

