/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.deployment.util.webservice;

/**
 * This class is used by the deployment tool to set the required information for jaxrpc-config.xml
 * that is passed as an argument to the wscompile tool. This class is to be used when the developer is
 * using the deploytool to generate WSDL given an SEI
 */

public class SEIConfig {

    private String webServiceName;
    private String nameSpace;
    private String packageName;
    private String interfaceName;
    private String servantName;

    /**
     * Constructor takes all required arguments and sets them appropriately
     * @param svcName Name of the webservice
     * @param space   namespace to be used for the webservice
     * @param pkg     the package name where the SEI and its implementations are present
     * @param svcIntf the name of the SEI 
     * @param svcImpl the name of SEI implementation
     */
    
    public SEIConfig(String svcName, String space, String pkg, String svcIntf, String svcImpl) {
        this.webServiceName = svcName;
        this.nameSpace = space;
        this.packageName = pkg;
        this.interfaceName = svcIntf;
        this.servantName = svcImpl;
    }
    
    public String getWebServiceName() { return this.webServiceName; }
    
    public String getNameSpace() { return this.nameSpace; }
    
    public String getPackageName() { return this.packageName; }
    
    public String getInterface() { return this.interfaceName; }
    
    public String getServant() { return this.servantName; }
}
