/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * Classpath.java
 *
 * Created on September 28, 2001, 11:34 PM
 */

package com.sun.enterprise.util.diagnostics;
import com.sun.enterprise.util.diagnostics.Reporter;
import java.util.*;

/**
 *
 * @author  bnevins
 * @version 
 */

public class Classpath
{
	public static List getClasspathAsList()
	{
		String			cp		= getClasspathAsString();
		String			ps		= System.getProperty("path.separator");
		StringTokenizer st		= new StringTokenizer(cp, ps);
		List			list	= new ArrayList();
		
		while (st.hasMoreTokens()) 
		{
			list.add(st.nextToken());
		}
		
		return list;
	}
	
	public static List getClasspathAsBatchCommands()
	{
		List from = getClasspathAsList();
		List to	= new ArrayList();
		
		boolean first = true;
		
		for(Iterator iter = from.iterator(); iter.hasNext(); )
		{
			if(first)
			{
				to.add("set CLASSPATH=" + iter.next());
				first = false;
			}
			else
				to.add("set CLASSPATH=%CLASSPATH%;" + iter.next());
		}
		
		return to;
	}

	public static String getClasspathAsString()
	{
		return System.getProperty("java.class.path");
	}

	public static List getClasspathAsSortedList()
	{
		List list = getClasspathAsList();
		Collections.sort(list, String.CASE_INSENSITIVE_ORDER);
		return list;
	}
		
	
	public static void main(String[] args)
	{
		pr("******  CLASSPATH as String *******");
		pr(getClasspathAsString());
		pr("******  CLASSPATH as List *******");
		pr(getClasspathAsList());
		pr("******  CLASSPATH as Sorted List *******");
		pr(getClasspathAsSortedList());
		pr("******  CLASSPATH as Batch Commands *******");
		pr(getClasspathAsBatchCommands());
	}
	
	private static void pr(String s)
	{
		System.out.println(s);
	}
	
	private static void pr(List c)
	{
		for(Iterator iter = c.iterator(); iter.hasNext(); )
		{
			pr((String)iter.next());
		}
	}
	
}
