/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.webservice.monitoring;

import com.sun.enterprise.deployment.WebServiceEndpoint;
/**
 * This interface defines all information and behaviour 
 * accessible from a particular endpoint. 
 *
 * @author Jerome Dochez
 */
public interface Endpoint {    
    
    /** 
     * @return the endpoint selector as a string. For Http transport endpoing, 
     * this is the URL web service clients use to invoke the endpoint.
     */
    public String getEndpointSelector();
    
    /**
     * @return the endpoint type
     */
    public EndpointType getEndpointType();
    
    /**
     * Returns the transport
     */
    public TransportType getTransport();
    
    /**
     * Returns the Deployment Descriptors associated with this endpoint
     */
    public WebServiceEndpoint getDescriptor();
    
    /**
     * registers a new SOAPMessageListener for this endpoint
     * @param newListener the listener instance to register.
     */
    public void addListener(MessageListener newListener);
    
    /**
     * unregiters a SOAPMessageListener for this endpoint
     * @param listener the listener instance to unregister.
     */
    public void removeListener(MessageListener listener);
}
