/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.ejb.base.stats;

import javax.management.j2ee.statistics.CountStatistic;
import javax.management.j2ee.statistics.TimeStatistic;

import com.sun.ejb.spi.stats.MonitorableSFSBStoreManager;

import com.sun.enterprise.admin.monitor.stats.CountStatisticImpl;
import com.sun.enterprise.admin.monitor.stats.MutableCountStatisticImpl;
import com.sun.enterprise.admin.monitor.stats.MutableTimeStatisticImpl;
import com.sun.enterprise.admin.monitor.stats.TimeStatisticImpl;

/**
 * An instance of this class is used by the StatefulContainer to update monitoring 
 *  data. There is once instance of this class per StatefulEJBContainer
 *
 * @author Mahesh Kannan
 */

public class HAStatefulSessionStoreMonitor
    extends StatefulSessionStoreMonitor
{

    private HAStatefulSessionStoreStatsImpl haStatsImpl;

    protected void setDelegate(HAStatefulSessionStoreStatsImpl delegate) {
	this.haStatsImpl = delegate;
	super.setDelegate(delegate);
    }

    public final void incrementCheckpointCount(boolean success) {
	HAStatefulSessionStoreStatsImpl delegate = haStatsImpl;
	if (delegate != null) {
	    delegate.incrementCheckpointCount(success);
	}
    }

    public final void setCheckpointSize(long val) {
	HAStatefulSessionStoreStatsImpl delegate = haStatsImpl;
	if (delegate != null) {
	    delegate.setCheckpointSize(val);
	}
    }

    public final void setCheckpointTime(long val) {
	HAStatefulSessionStoreStatsImpl delegate = haStatsImpl;
	if (delegate != null) {
	    delegate.setCheckpointTime(val);
	}
    }

}
