/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.ejb.containers;

import javax.naming.*;
import javax.naming.spi.*;

import java.util.Hashtable;

import java.util.logging.*;
import com.sun.logging.*;

import com.sun.ejb.EJBUtils;

/**
 * An object factory to handle Remote EJB 30 business interface
 * reference access.
 */

public class RemoteBusinessObjectFactory implements ObjectFactory {


    static Logger _logger = LogDomains.getLogger(LogDomains.EJB_LOGGER);

    public Object getObjectInstance(Object obj, 
				    Name name, 
				    Context nameCtx,
				    Hashtable env) throws Exception 
    {

	InitialContext ic = new InitialContext();

	Reference ref = (Reference) obj;

	RefAddr refAddr = ref.get("url");

	Object genericRemoteHomeObj = ic.lookup((String) refAddr.getContent());

        String busInterface = ref.getClassName();
        
	return EJBUtils.lookupRemote30BusinessObject(genericRemoteHomeObj,
                                                     busInterface);
    }

}
