/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.ejb.containers.util.cache;

import com.sun.ejb.containers.StatefulSessionContainer;

import java.util.*;
import java.util.logging.*;
import com.sun.logging.*;

import java.util.TimerTask;
import com.sun.logging.*;

public class UnBoundedSessionCache
	extends LruSessionCache
{

    public UnBoundedSessionCache(String cacheName, 
                                 StatefulSessionContainer container, 
                                 int cacheIdleTime, int removalTime) {
        super(cacheName, container, cacheIdleTime, removalTime);
        threshold = Integer.MAX_VALUE;
    }
    
    
    protected boolean isThresholdReached() {
        return false;
    }
    
    protected CacheItem trimLru() {
        threshold *= 2;
        return null;
    }

}
