/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise;

import java.security.Principal;
import java.security.PrivilegedExceptionAction;
import java.lang.reflect.Method;
import com.sun.ejb.*;
import javax.security.auth.Subject;
import com.sun.enterprise.security.CachedPermission;

/**
 * This interface is used by the Container to manage access to EJBs.
 * The container has a reference to an implementation of this 
 * interface.
 * @author Harish Prabandham
 */
public interface SecurityManager {

    /**
     * @param The Invocation object containing the details of the invocation.
     * @return true if the client is allowed to invoke the EJB, false otherwise.
     */
    public boolean authorize(Invocation inv);

    /**
     * @return The Principal of the client who made the current 
     * invocation.
     */
    public Principal getCallerPrincipal();

    /**
     * @return A boolean true/false depending on whether or not the caller 
     * has the specified role.
     * @param The EJB developer specified "logical role".
     */
    public boolean isCallerInRole(String  role);


    /** This sets up the security context - if not set
     * and does run-as related login if required
     * @param ComponentInvocation
     */
    public void preInvoke (ComponentInvocation inv);

    /**
     * This method is used by the  Invocation Manager to remove
     * the run-as identity information that was set up using the 
     * preInvoke
     * @param ComponentInvocation
     */
    public void postInvoke (ComponentInvocation inv);

    /**
     * Call this method to clean up all the bookeeping
     * data-structures in the SM.
     */
    public void destroy();

    /**
     * This will return the subject associated with the current
     * call. If the run as subject is in effect. It will return that
     * subject. This is done to support the JACC specification which says
     * if the runas principal is in effect, that principal should be used
     * for making a component call.
     * @return Subject the current subject. Null if this is not the
     * runas case
     */
    public Subject getCurrentSubject();
    
    /* This method is used by SecurityUtil runMethod to run the
     * action as the subject encapsulated in the cuurent
     * SecurityContext.
     */
      
    public Object doAsPrivileged(PrivilegedExceptionAction pea) 
 	throws Throwable;
     
}
