/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.admin.common;

import java.io.Serializable;

import com.sun.enterprise.admin.common.Param;
import com.sun.enterprise.admin.common.AdminResponse;
import com.sun.enterprise.admin.common.constant.AdminConstants;

/**
 */
public class AdminResponseConfigurator
{
    private final AdminResponse response;

    /**
     * Creates new AdminResponseConfigurator
     */
    public AdminResponseConfigurator(AdminResponse response)
    {
        //ArgChecker.check(response);
        this.response = response;
    }

    /**
     */
    public void setException(Throwable t)
    {
        //ArgChecker.check(t); Do we need this check?
        response.addParam(new Param(AdminConstants.EXCEPTION, t));
    }

    public boolean hasException()
    {
        Param param = response.getParam(AdminConstants.EXCEPTION);
        if (param != null)
        {
            return (param.mValue != null);
        }
        return false;
    }

    public Throwable getException()
    {
        Throwable t = null;
        if (hasException())
        {
            Param param = response.getParam(AdminConstants.EXCEPTION);
            t = (Throwable)param.mValue;
        }
        return t;
    }

    public void setReturnValue(Serializable value)
    {
        response.addParam(new Param(AdminConstants.RETURN_VALUE, value));
    }

    public Object getReturnValue()
    {
        Object returnValue = null;
        Param param = response.getParam(AdminConstants.RETURN_VALUE);
        if (param != null)
        {
            returnValue = (Object)param.mValue;
        }
        return returnValue;
    }
}