/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * RMIMultiHomedServerSocketFactory.java
 * Indentation Information:
 * 0. Please (try to) preserve these settings.
 * 1. No tabs are used, all spaces.
 * 2. In vi/vim -
 *      :set tabstop=4 :set shiftwidth=4 :set softtabstop=4
 * 3. In S1 Studio -
 *      1. Tools->Options->Editor Settings->Java Editor->Tab Size = 4
 *      2. Tools->Options->Indentation Engines->Java Indentation Engine->Expand Tabs to Spaces = True.
 *      3. Tools->Options->Indentation Engines->Java Indentation Engine->Number of Spaces per Tab = 4.
 * Unit Testing Information:
 * 0. Is Standard Unit Test Written (y/n):
 * 1. Unit Test Location: (The instructions should be in the Unit Test Class itself).
 */

package com.sun.enterprise.admin.server.core.jmx.nonssl;

import com.sun.enterprise.config.serverbeans.AdminService;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.JmxConnector;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.server.ServerContext;
import java.rmi.server.RMIServerSocketFactory;
import java.net.ServerSocket;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.server.RMIServerSocketFactory;
import java.security.SecureRandom;
import javax.management.remote.JMXConnector;

/** This is the custom RMI server socket factory that helps bind RMI servers to a specific
 * IP interface as has been specified in the domain->config->admin-service->jmx-connector->address
 * in domain.xml. In the absence of a specific entry, the default RMI behavior of binding to all
 * IP interfaces on the host is observed.   
 * @author  Nandini.Ektare@sun.com
 * @since Sun Java System Application Server 8.1 UR 2
 */
public class RMIMultiHomedServerSocketFactory implements RMIServerSocketFactory {

    private static final String DEFAULT_ADDRESS = "0.0.0.0";
    
    private String address = DEFAULT_ADDRESS;

    public RMIMultiHomedServerSocketFactory(String host) { 
	address = host;
        /*ServerContext serverCtx = ApplicationServer.getServerContext();
	if (serverCtx != null) {
	    try {
                ConfigContext configCtx = serverCtx.getConfigContext();
                Config config = ServerBeansFactory.getConfigBean(configCtx);	
                AdminService as = config.getAdminService();
                JmxConnector[] jc = as.getJmxConnector();
                address = jc[0].getAddress(); 
            } catch (ConfigException ex) {
                return null;
            }
	}*/
    }
    
    /** Implementation of the only method in {@link RMIServerSocketFactory}. This
     * method is called for creating the server socket.
     * @return instance of ServerSocket
     */
    public ServerSocket createServerSocket(int port) throws IOException {
        try {
            InetAddress bindAddress = null;
            ServerSocket ss = null;        
            if (address.equals(DEFAULT_ADDRESS))             
                ss = new ServerSocket(port);        
            else {            
                bindAddress = InetAddress.getByName(address);             
                ss = new ServerSocket(port, 0, bindAddress);        
            }
            debug(ss);
            return (ss);
        } catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }
    
    /**
     * Overriding the base class method here to ensure that when a functionally
     * equivalent instance of server socket factory is passed, the same factory 
     * is reused instead of creating new objects
     */
    public boolean equals(Object anotherFactory) {
        
        if (anotherFactory != null && 
       	    anotherFactory.getClass().equals(this.getClass())) {
    
            RMIMultiHomedServerSocketFactory rmhssf = 
                (RMIMultiHomedServerSocketFactory) anotherFactory;
    
            if (this.address == null && rmhssf.address == null) return true;
            if (this.address == null ^ rmhssf.address == null) return false;
	    return this.address.equals(rmhssf.address);
        }
        return false;
    }
    
    private void debug (ServerSocket sss) {
        // prints the debug information - suppress after beta
        String prefix = "RMI/TLS Server Debug Message: " ;
        boolean DEBUG = Boolean.getBoolean("Debug");
        if (sss != null) {
            if (DEBUG) {
                System.out.println(prefix + "ServerSocket local port = " + sss.getLocalPort());
                System.out.println(prefix + "ServerSocket host address = " + sss.getInetAddress().getHostAddress());
                System.out.println(prefix + "ServerSocket bound status = " + sss.isBound());
            }
        }
        else {
            System.out.println(prefix + " Catastrophe: no server socket");
        }
    }
}
