/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.appclient.jws;

import com.sun.enterprise.web.AdHocServletInfo;
import java.util.HashMap;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 *Info describing the ad hoc servlet that is dynamically registered with the web 
 *container to receive Java Web Start's requests for the JNLP document.
 *<p>
 *The web container uses this information in setting up the dynamic mapping
 *from URLs to our code.
 *
 * @author tjquinn
 */
public class JWSAdHocServletInfo implements AdHocServletInfo {
    
    /** holds init parameter names and values that will be available to the servlet */
    private HashMap<String,String> initParams;
    
    /** Creates a new instance of JWSAdHocServletInfo */
    public JWSAdHocServletInfo(String virtualContextRoot, String category) {
        setInitParams(virtualContextRoot, category);
    }

    /**
     *Reports which class implements the ad hoc servlet to be run.
     *@return Class for the ad hoc servlet class
     */
    public Class getServletClass() {
        return JWSAdHocServlet.class;
    }

    /**
     *Returns a map from servlet init param name to value.
     *@return Map<String,String> of init param names to values
     */
    public java.util.Map<String, String> getServletInitParams() {
        return initParams;
    }

    /**
     *Reports the servlet's name.
     *@return the name of the servlet for display purposes
     */
    public String getServletName() {
        return "Java Web Start ad hoc servlet";
    }
    
    /**
     *Sets up the map of init param names to values that will be retrieved
     *by the web container.
     *@param the context root by which the ad hoc servlet will be addressed
     *@param the category (basically either application or appclient)
     */
    private void setInitParams(String virtualContextRoot, String category) {
        initParams = new HashMap<String,String>();
        initParams.put(JWSAdHocServlet.CONTEXT_ROOT_PARAMETER_NAME, virtualContextRoot);
        initParams.put(JWSAdHocServlet.CATEGORY_PARAMETER_NAME, category);
    }
}
