/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.appclient.jws;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;

/**
 *Manages the caching and retrieval of templates used for generating JNLP and
 *HTML documents to be served to Java Web Start.
 *
 * @author tjquinn
 */
public class TemplateCache {
    
    /** path relative to this class where the templates reside */
    private static final String TEMPLATES_PATH_PREFIX = "templates/";

    /** caches templates */
    private Map<String,String> templateCache;
    
    
    /** Creates a new instance of TemplateCache */
    public TemplateCache() {
        templateCache = new HashMap<String,String>();
    }
    
    /**
     *Returns a template retrieved using the path specified.
     *@param name of the template, relative to the current package
     *@return the retrieved template as a String
     *@throws IOException reporting any error retrieving the template as a resource
     */
    public String getTemplate(String templateName) throws IOException {
        
        /*
         *Look for the named template in the cache and, if it is not there, 
         *retrieve it and store it in the cache.
         */
        String template = templateCache.get(templateName);
        if (template == null) {
            template = Util.loadResource(this.getClass(), TEMPLATES_PATH_PREFIX + templateName);
            templateCache.put(templateName, template);
        }
        
        /*
         *Regardless of how the template was found, return it.
         */
        return template;
    }
}