/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.deployment.backend;

import java.util.Collections;
import java.util.Map;
import java.util.HashMap;
import java.util.Iterator;

import com.sun.enterprise.util.i18n.StringManager;

/**
 * This registry singleton class will maintain a list of 
 * oustanding DeploymentRequest instances keyed by the 
 * DeploymentID they are serving. 
 *
 * @author Jerome Dochez
 */
public class DeploymentRequestRegistry {
    
    // singleton instance
    static DeploymentRequestRegistry instance=null;
    
    // the map of deployment id to deployment requests
    Map idToRequest = Collections.synchronizedMap(new HashMap());    
    
    /** string manager */
    private static StringManager localStrings =
        StringManager.getManager( DeploymentRequestRegistry.class );

    /** Creates a new instance of DeploymentRequestRegistry */
    private DeploymentRequestRegistry() {
    }
    
    /**
     * @return the singleton instance of this registry
     */ 
    public static DeploymentRequestRegistry getRegistry() {
        if (instance==null) {
            synchronized(DeploymentRequestRegistry.class) {
                if (instance==null) {
                    instance = new DeploymentRequestRegistry();
                }
            };
        }
        return instance;
    }
    
    /**
     * add new new request to the registry
     * @param the module identifier
     * @param the deployment request
     */
    public void addDeploymentRequest(String id, 
        DeploymentRequest request) throws IASDeploymentException { 
        synchronized(DeploymentRequestRegistry.class) {
            // if there is another thread operating on the same module
            // at the same time, we need to abort this deployment
            if (idToRequest.containsKey(id)) {
                String msg = localStrings.getString(
                    "another_thread_access_same_module",
                    new Object[]{ id });
                throw new IASDeploymentException(msg);
            }
            idToRequest.put(id, request);
        }
    }

    /**
     * remove request from the registry
     * @param the module identifier
     */
    public void removeDeploymentRequest(String id) { 
        idToRequest.remove(id);
    }

    
    /** 
     * @return the deployment request associated with the passed module ID
     */
    public DeploymentRequest getDeploymentRequest(String id) {
        return (DeploymentRequest) idToRequest.get(id);
    }
}
