/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.deployment.interfaces;

import com.sun.enterprise.deployment.deploy.shared.AbstractArchive;
import com.sun.enterprise.deployment.RootDeploymentDescriptor;
import com.sun.enterprise.util.zip.ZipItem;

import java.io.IOException;
import java.util.Properties;

/**
 * This interface defines behaviour necessary for creating a appclient container
 * compliant jar file.
 * 
 * @author Jerome Dochez
 */
public interface ClientJarMaker {

	/**
 	* creates the appclient container jar file 
 	* @param descriptor is the loaded module's deployment descriptor
 	* @param source is the abstract archive for the source module deployed
 	* @param target is the abstract archive for the desired appclient container jar file
 	* @param stubs are the stubs generated by the deployment codegen 
 	* @param props is a properties collection to pass implementation parameters
 	* 
 	* @throws IOException when the jar file creation fail
 	*/
	public void create(RootDeploymentDescriptor descriptor, AbstractArchive source, 
			AbstractArchive target, ZipItem[] stubs, Properties props)
		throws IOException; 

        /**
        * creates the appclient container jar file
        * @param descriptor is the loaded module's deployment descriptor
        * @param source is the abstract archive for the source module deployed
        * @param source2 is the abstract archive for the generated xml directory
        * @param target is the abstract archive for the desired appclient container jar file
        * @param stubs are the stubs generated by the deployment codegen
        * @param props is a properties collection to pass implementation parameters
        *
        * @throws IOException when the jar file creation fail
        */
        public void create(RootDeploymentDescriptor descriptor, AbstractArchive source, AbstractArchive source2, AbstractArchive target, ZipItem[] stubs, Properties props)
                throws IOException;

}
